/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.adapter;

import com.zaxxer.hikari.HikariDataSource;
import de.syntaxjason.adapter.PersistenceAdapter;
import de.syntaxjason.crypto.CryptoRegistry;
import de.syntaxjason.dialect.SqlDialect;
import de.syntaxjason.mapper.RowMapper;
import de.syntaxjason.meta.EntityMeta;
import de.syntaxjason.meta.FieldMeta;
import de.syntaxjason.meta.IndexMeta;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class JdbcAdapter
implements PersistenceAdapter {
    private final HikariDataSource dataSource;
    private final SqlDialect dialect;
    private final RowMapper rowMapper;

    public JdbcAdapter(HikariDataSource dataSource, SqlDialect dialect) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.rowMapper = new RowMapper();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean insert(EntityMeta meta, Object entity) {
        InsertPlan plan = this.buildInsertPlan(meta, entity);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = connection.prepareStatement(plan.sql, 1);
                try {
                    this.bindParameters(ps, plan.parameters);
                    int updated = ps.executeUpdate();
                    this.assignGeneratedId(meta, ps, entity);
                    boolean bl2 = bl = updated > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Insert failed for " + meta.tableName(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean update(EntityMeta meta, Object entity) {
        UpdatePlan plan = this.buildUpdatePlan(meta, entity);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = connection.prepareStatement(plan.sql);
                try {
                    this.bindParameters(ps, plan.parameters);
                    int updated = ps.executeUpdate();
                    boolean bl2 = bl = updated > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Update failed for " + meta.tableName(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(EntityMeta meta, Object entity) {
        String sql = this.dialect.delete(meta);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = connection.prepareStatement(sql);
                try {
                    Object idValue = meta.primaryKeyField().getter().apply(entity);
                    ps.setObject(1, idValue);
                    int updated = ps.executeUpdate();
                    boolean bl2 = bl = updated > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Delete failed for " + meta.tableName(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> Optional<T> findById(EntityMeta meta, Object id, Class<T> type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> List<T> queryByFields(EntityMeta meta, Class<T> type, String[] columns, Object[] values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> List<T> findAll(EntityMeta meta, Class<T> type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void ensureSchema(EntityMeta meta) {
        String ddl = this.dialect.createTable(meta);
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(ddl);
        }
        catch (SQLException e) {
            throw new RuntimeException("Schema creation failed for " + meta.tableName(), e);
        }
    }

    @Override
    public void ensureIndexes(EntityMeta meta) {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            for (IndexMeta index : meta.indexes()) {
                String sql = this.dialect.createIndex(meta.tableName(), index.name(), index.fields(), index.unique(), index.type());
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Index creation failed for " + meta.tableName(), e);
        }
    }

    private void bindParameters(PreparedStatement ps, List<Object> parameters) throws SQLException {
        int idx = 1;
        for (Object parameter : parameters) {
            ps.setObject(idx++, parameter);
        }
    }

    private void assignGeneratedId(EntityMeta meta, PreparedStatement ps, Object entity) throws SQLException {
        if (!meta.primaryKeyField().autoIncrement()) {
            return;
        }
        try (ResultSet keys = ps.getGeneratedKeys();){
            if (keys.next()) {
                Object id = keys.getObject(1);
                meta.primaryKeyField().setter().accept(entity, id);
            }
        }
    }

    private String buildSelectByColumns(EntityMeta meta, String[] columns) {
        if (columns == null || columns.length == 0) {
            return "SELECT * FROM " + meta.tableName();
        }
        StringBuilder sb = new StringBuilder("SELECT * FROM ").append(meta.tableName()).append(" WHERE ");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(columns[i]).append(" = ?");
        }
        return sb.toString();
    }

    private InsertPlan buildInsertPlan(EntityMeta meta, Object entity) {
        List<FieldMeta> candidates = meta.insertableFields();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (FieldMeta field : candidates) {
            Object value = field.getter().apply(entity);
            if (field.isEncrypted()) {
                String plain = value == null ? null : String.valueOf(value);
                value = CryptoRegistry.getCryptoService().encrypt(plain);
            }
            if (value == null) continue;
            columnNames.add(field.column());
            values.add(this.coerceJdbcValue(value));
        }
        String columns = String.join((CharSequence)", ", columnNames);
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(values.size(), "?"));
        String sql = "INSERT INTO " + meta.tableName() + " (" + columns + ") VALUES (" + placeholders + ")";
        return new InsertPlan(sql, values);
    }

    private UpdatePlan buildUpdatePlan(EntityMeta meta, Object entity) {
        List<FieldMeta> candidates = meta.updatableFields();
        ArrayList<CallSite> setClauses = new ArrayList<CallSite>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (FieldMeta field : candidates) {
            Object value = field.getter().apply(entity);
            if (field.isEncrypted()) {
                String plain = value == null ? null : String.valueOf(value);
                value = CryptoRegistry.getCryptoService().encrypt(plain);
            }
            setClauses.add((CallSite)((Object)(field.column() + " = ?")));
            values.add(this.coerceJdbcValue(value));
        }
        Object idValue = meta.primaryKeyField().getter().apply(entity);
        values.add(idValue);
        String sql = "UPDATE " + meta.tableName() + " SET " + String.join((CharSequence)", ", setClauses) + " WHERE " + meta.primaryKeyColumn() + " = ?";
        return new UpdatePlan(sql, values);
    }

    private Object coerceJdbcValue(Object value) {
        if (value instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)value;
            return Timestamp.valueOf(ldt);
        }
        if (value instanceof LocalDate) {
            LocalDate ld = (LocalDate)value;
            return Date.valueOf(ld);
        }
        return value;
    }

    private record InsertPlan(String sql, List<Object> parameters) {
    }

    private record UpdatePlan(String sql, List<Object> parameters) {
    }
}

