/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;

public class AnnotationUtil {
    public static boolean classHasAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return clazz.isAnnotationPresent(annotationClass);
    }

    public static <A extends Annotation> A getClassAnnotation(Class<?> clazz, Class<A> annotationClass) {
        return clazz.getAnnotation(annotationClass);
    }

    public static Annotation[] getClassAnnotations(Class<?> clazz) {
        return clazz.getAnnotations();
    }

    public static boolean methodHasAnnotation(Method method, Class<? extends Annotation> annotationClass) {
        return method.isAnnotationPresent(annotationClass);
    }

    public static <A extends Annotation> A getMethodAnnotation(Method method, Class<A> annotationClass) {
        return method.getAnnotation(annotationClass);
    }

    public static Annotation[] getMethodAnnotations(Method method) {
        return method.getAnnotations();
    }

    public static boolean fieldHasAnnotation(Field field, Class<? extends Annotation> annotationClass) {
        return field.isAnnotationPresent(annotationClass);
    }

    public static <A extends Annotation> A getFieldAnnotation(Field field, Class<A> annotationClass) {
        return field.getAnnotation(annotationClass);
    }

    public static Annotation[] getFieldAnnotations(Field field) {
        return field.getAnnotations();
    }

    public static Method[] getMethodsByAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return (Method[])Arrays.stream(clazz.getMethods()).filter(method -> method.isAnnotationPresent(annotationClass)).toArray(Method[]::new);
    }

    public static Field[] getFieldsByAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotationClass)).toArray(Field[]::new);
    }

    public static Annotation[] getParameterAnnotations(Parameter parameter) {
        return parameter.getAnnotations();
    }
}

