/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import me.syntaxjason.config.ConfigManager;

public class TomlConfiguration
implements ConfigManager {
    private TomlMapper tomlMapper;
    private String configFilePath;
    private Map<String, Object> configData;

    public TomlConfiguration(String configFilePath) throws IOException {
        this.configFilePath = configFilePath;
        this.tomlMapper = new TomlMapper();
        this.loadConfig();
    }

    @Override
    public Map<String, Object> loadConfig() throws IOException {
        File configFile = new File(this.configFilePath);
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        this.configData = (Map)this.tomlMapper.readValue(configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return this.configData;
    }

    @Override
    public <T> T getConfigValue(String key, Class<T> type) {
        Object value = this.configData.get(key);
        return (T)this.tomlMapper.convertValue(value, type);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        this.configData.put(key, value);
        try {
            this.tomlMapper.writeValue(new File(this.configFilePath), this.configData);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config to file", e);
        }
    }

    @Override
    public <T> T convertValue(Object value, Class<T> type) {
        return (T)this.tomlMapper.convertValue(value, type);
    }
}

