/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import me.syntaxjason.config.ConfigManager;

public class JsonConfiguration
implements ConfigManager {
    private ObjectMapper objectMapper;
    private String configFilePath;
    private Map<String, Object> configData;

    public JsonConfiguration(String configFilePath) throws IOException {
        this.configFilePath = configFilePath;
        this.objectMapper = new ObjectMapper();
        this.loadConfig();
    }

    @Override
    public Map<String, Object> loadConfig() throws IOException {
        File configFile = new File(this.configFilePath);
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        this.configData = (Map)this.objectMapper.readValue(configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return this.configData;
    }

    @Override
    public <T> T getConfigValue(String key, Class<T> type) {
        Object value = this.configData.get(key);
        return (T)this.objectMapper.convertValue(value, type);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        this.configData.put(key, value);
        try {
            this.objectMapper.writeValue(new File(this.configFilePath), this.configData);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config to file", e);
        }
    }

    @Override
    public <T> T convertValue(Object value, Class<T> type) {
        return (T)this.objectMapper.convertValue(value, type);
    }
}

