/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import me.syntaxjason.ConfigurationType;
import me.syntaxjason.annotation.ConfigParam;
import me.syntaxjason.annotation.ConfigSource;
import me.syntaxjason.config.ConfigManager;
import me.syntaxjason.config.JsonConfiguration;
import me.syntaxjason.config.TomlConfiguration;
import me.syntaxjason.config.YamlConfiguration;

public class ConfigurationProvider {
    private static ConfigurationProvider instance;
    private Map<String, Object> configData = new HashMap<String, Object>();
    private ConfigManager manager;

    public static ConfigurationProvider getInstance() {
        if (instance == null) {
            instance = new ConfigurationProvider();
        }
        return instance;
    }

    public Object loadConfiguration(Class<?> configClass) throws Exception {
        if (configClass.isAnnotationPresent(ConfigSource.class)) {
            ConfigSource source = configClass.getAnnotation(ConfigSource.class);
            ConfigurationType configType = source.type();
            switch (configType) {
                case JSON: {
                    this.manager = new JsonConfiguration(source.value());
                    break;
                }
                case YAML: {
                    this.manager = new YamlConfiguration(source.value());
                    break;
                }
                case TOML: {
                    this.manager = new TomlConfiguration(source.value());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported configuration type: " + configType);
                }
            }
            Map<String, Object> configData = this.manager.loadConfig();
            Object configInstance = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.bindConfig(configInstance, configData);
            return configInstance;
        }
        throw new IllegalArgumentException("No @ConfigSource annotation present on the class.");
    }

    private void bindConfig(Object configInstance, Map<String, Object> configData) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = configInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigParam.class)) continue;
            ConfigParam param = field.getAnnotation(ConfigParam.class);
            Object value = configData.getOrDefault(param.name(), param.defaultValue());
            field.setAccessible(true);
            field.set(configInstance, this.manager.convertValue(value, field.getType()));
        }
    }
}

