/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import me.syntaxjason.config.IConfigManager;

public class YamlConfiguration
implements IConfigManager {
    private Map<String, Object> configData;
    private Map<String, String> comments;
    private YAMLMapper yamlMapper;
    private String filePath;
    private String classComment;

    public YamlConfiguration(String filePath, String classComment) throws IOException {
        this.filePath = filePath;
        this.yamlMapper = new YAMLMapper();
        this.comments = new HashMap<String, String>();
        this.classComment = classComment;
        this.loadConfig();
    }

    @Override
    public void loadConfig() throws IOException {
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            this.configData = new HashMap<String, Object>();
            return;
        }
        if (configFile.length() == 0L) {
            this.configData = new HashMap<String, Object>();
            return;
        }
        StringBuilder content = new StringBuilder();
        Files.lines(configFile.toPath()).forEach(line -> {
            if (line.trim().startsWith("#")) {
                int separatorIndex = line.indexOf(":");
                if (separatorIndex > 0) {
                    String key = line.substring(1, separatorIndex).trim();
                    String comment = line.substring(separatorIndex + 1).trim();
                    this.comments.put(key, comment);
                }
                return;
            }
            content.append((String)line).append("\n");
        });
        this.configData = (Map)this.yamlMapper.readValue(content.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public void saveConfig() throws IOException {
        StringBuilder content = new StringBuilder();
        if (this.classComment != null && !this.classComment.isEmpty()) {
            content.append("# ").append(this.classComment).append("\n\n\n");
        }
        for (String key : this.configData.keySet()) {
            if (this.comments.containsKey(key)) {
                content.append("# ").append(this.comments.get(key)).append("\n");
            }
            content.append(key).append(": ").append(this.yamlMapper.writeValueAsString(this.configData.get(key)).trim()).append("\n");
        }
        Files.write(new File(this.filePath).toPath(), content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                current.put((String)token, (Object)value);
                return;
            }
            current = (Map)current.computeIfAbsent((String)token, k -> new HashMap());
        }
    }

    @Override
    public <T> T getConfigValue(String key, Class<T> type) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                return type.cast(current.get(token));
            }
            current = (Map)current.get(token);
        }
        return null;
    }

    @Override
    public Map<String, Object> getConfigData() {
        return new HashMap<String, Object>(this.configData);
    }

    @Override
    public void setConfigComment(String key, String comment) {
        this.comments.put(key, comment);
    }
}

