/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.syntaxjason.annotation.Comment;
import me.syntaxjason.annotation.ConfigParam;
import me.syntaxjason.annotation.ConfigSource;
import me.syntaxjason.config.IConfigManager;

public class ConfigurationProxy
implements InvocationHandler {
    private IConfigManager configManager;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Set<String> modifiedKeys = new HashSet<String>();
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, Boolean> copyDefaults = new HashMap<String, Boolean>();
    private boolean autoSave;
    private Map<String, String> comments = new HashMap<String, String>();
    private boolean debug = false;

    public ConfigurationProxy(IConfigManager configManager, Class<?> configInterface) {
        ConfigSource source = configInterface.getAnnotation(ConfigSource.class);
        this.autoSave = source.autoSave();
        this.configManager = configManager;
        try {
            this.configManager.loadConfig();
            Map<String, Object> loadedValues = this.configManager.getConfigData();
            for (String key : loadedValues.keySet()) {
                this.values.put(key, loadedValues.get(key));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load configuration", e);
        }
        for (Method method : configInterface.getMethods()) {
            if (!method.isAnnotationPresent(ConfigParam.class)) continue;
            ConfigParam param = method.getAnnotation(ConfigParam.class);
            this.defaults.put(method.getName(), param.defaultValue());
            this.copyDefaults.put(method.getName(), param.copyDefault());
            Comment comment = method.getAnnotation(Comment.class);
            if (comment == null) continue;
            this.comments.put(method.getName(), comment.value());
        }
        try {
            this.saveConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T create(Class<T> configInterface, IConfigManager configManager) {
        return (T)Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)new ConfigurationProxy(configManager, configInterface));
    }

    public void debug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("reload")) {
            this.configManager.loadConfig();
            Map<String, Object> loadedValues = this.configManager.getConfigData();
            for (String key : loadedValues.keySet()) {
                this.values.put(key, loadedValues.get(key));
            }
            return null;
        }
        if (methodName.startsWith("get") && args == null) {
            String propertyKey = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Object value = this.values.get(propertyKey);
            if (value == null && this.defaults.containsKey(methodName)) {
                if (this.copyDefaults.containsKey(methodName) && this.copyDefaults.get(methodName).booleanValue()) {
                    this.saveConfiguration();
                }
                return method.getReturnType().cast(this.defaults.get(methodName));
            }
            return this.values.getOrDefault(propertyKey, method.getDefaultValue());
        }
        if (methodName.startsWith("set") && args.length == 1) {
            String propertyKey = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            this.values.put(propertyKey, args[0]);
            if (this.autoSave) {
                this.saveConfiguration();
            }
            return null;
        }
        return method.invoke((Object)this.configManager, args);
    }

    public void saveConfiguration() throws Exception {
        for (String key : this.modifiedKeys) {
            this.configManager.setConfigValue(key, this.values.get(key));
        }
        for (String ds : this.defaults.keySet()) {
            if (!this.copyDefaults.containsKey(ds) || !this.copyDefaults.get(ds).booleanValue()) continue;
            this.configManager.setConfigValue(Character.toLowerCase(ds.charAt(3)) + ds.substring(4), this.defaults.get(ds));
        }
        for (String method : this.comments.keySet()) {
            String propertyKey = Character.toLowerCase(method.charAt(3)) + method.substring(4);
            this.configManager.setConfigComment(propertyKey, this.comments.get(method));
        }
        this.configManager.saveConfig();
        this.modifiedKeys.clear();
    }
}

