/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import me.syntaxjason.config.IConfigManager;

public class TomlConfiguration
implements IConfigManager {
    private Map<String, Object> configData;
    private Map<String, String> comments;
    private TomlMapper tomlMapper;
    private String filePath;
    private String classComment;

    public TomlConfiguration(String filePath, String classComment) throws IOException {
        this.filePath = filePath;
        this.tomlMapper = new TomlMapper();
        this.comments = new HashMap<String, String>();
        this.classComment = classComment;
        this.loadConfig();
    }

    @Override
    public void loadConfig() throws IOException {
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            this.configData = new HashMap<String, Object>();
            return;
        }
        if (configFile.length() == 0L) {
            this.configData = new HashMap<String, Object>();
            return;
        }
        this.configData = new HashMap<String, Object>();
        Files.lines(configFile.toPath()).forEach(line -> {
            int separatorIndex;
            if (!(line = line.trim()).startsWith("#") && !line.isEmpty()) {
                try {
                    Map lineData = (Map)this.tomlMapper.readValue(line, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    this.configData.putAll(lineData);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (line.startsWith("#") && (separatorIndex = line.indexOf(":")) > 0) {
                String key = line.substring(1, separatorIndex).trim();
                String comment = line.substring(separatorIndex + 1).trim();
                this.comments.put(key, comment);
            }
        });
    }

    @Override
    public void saveConfig() throws IOException {
        StringBuilder content = new StringBuilder();
        if (this.classComment != null && !this.classComment.isEmpty()) {
            content.append("# ").append(this.classComment).append("\n\n\n");
        }
        for (String key : this.configData.keySet()) {
            if (this.comments.containsKey(key)) {
                content.append("# ").append(this.comments.get(key)).append("\n");
            }
            content.append(key).append(" = ").append(this.tomlMapper.writeValueAsString(this.configData.get(key)).trim()).append("\n");
        }
        Files.write(new File(this.filePath).toPath(), content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                current.put((String)token, (Object)value);
                return;
            }
            current = (Map)current.computeIfAbsent((String)token, k -> new HashMap());
        }
    }

    @Override
    public <T> T getConfigValue(String key, Class<T> type) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                return type.cast(current.get(token));
            }
            current = (Map)current.get(token);
        }
        return null;
    }

    @Override
    public Map<String, Object> getConfigData() {
        return new HashMap<String, Object>(this.configData);
    }

    @Override
    public void setConfigComment(String key, String comment) {
        this.comments.put(key, comment);
    }
}

