/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import me.syntaxjason.config.IConfigManager;

public class JsonConfiguration
implements IConfigManager {
    private Map<String, Object> configData;
    private Map<String, String> comments;
    private ObjectMapper objectMapper;
    private String filePath;
    private String classComment;

    public JsonConfiguration(String filePath, String classComment) throws IOException {
        this.filePath = filePath;
        this.objectMapper = new ObjectMapper();
        this.comments = new HashMap<String, String>();
        this.classComment = classComment;
        this.loadConfig();
    }

    @Override
    public void loadConfig() throws IOException {
        File configFile = new File(this.filePath);
        if (!configFile.exists() || configFile.length() == 0L) {
            this.configData = new HashMap<String, Object>();
            return;
        }
        this.configData = new HashMap<String, Object>();
        HashMap<String, String> rawData = new HashMap<String, String>();
        Files.lines(configFile.toPath()).forEach(line -> {
            if (line.startsWith("#")) {
                String[] parts = line.substring(1).split(":", 2);
                if (parts.length == 2) {
                    this.comments.put(parts[0].trim(), parts[1].trim());
                }
            } else {
                String[] parts = line.split(":", 2);
                if (parts.length == 2) {
                    rawData.put(parts[0].trim(), parts[1].trim());
                }
            }
        });
        rawData.forEach((key, value) -> {
            try {
                this.configData.put((String)key, this.objectMapper.readValue(value, Object.class));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void saveConfig() throws IOException {
        StringBuilder content = new StringBuilder();
        if (this.classComment != null && !this.classComment.isEmpty()) {
            content.append("# ").append(this.classComment).append("\n\n\n");
        }
        for (String key : this.configData.keySet()) {
            if (this.comments.containsKey(key)) {
                content.append("#").append(key).append(": ").append(this.comments.get(key)).append("\n");
            }
            content.append(key).append(": ").append(this.objectMapper.writeValueAsString(this.configData.get(key))).append("\n");
        }
        Files.write(new File(this.filePath).toPath(), content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                current.put((String)token, (Object)value);
                return;
            }
            current = (Map)current.computeIfAbsent((String)token, k -> new HashMap());
        }
    }

    @Override
    public <T> T getConfigValue(String key, Class<T> type) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                return type.cast(current.get(token));
            }
            current = (Map)current.get(token);
        }
        return null;
    }

    @Override
    public Map<String, Object> getConfigData() {
        return new HashMap<String, Object>(this.configData);
    }

    @Override
    public void setConfigComment(String key, String comment) {
        this.comments.put(key, comment);
    }
}

