/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import me.syntaxjason.config.IConfigManager;

public class TomlConfiguration
implements IConfigManager {
    private Map<String, Object> configData;
    private TomlMapper tomlMapper;
    private String filePath;

    public TomlConfiguration(String filePath) throws IOException {
        this.filePath = filePath;
        this.tomlMapper = new TomlMapper();
        this.loadConfig();
    }

    @Override
    public void loadConfig() throws IOException {
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            this.configData = new HashMap<String, Object>();
            return;
        }
        this.configData = (Map)this.tomlMapper.readValue(configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public void saveConfig() throws IOException {
        this.tomlMapper.writeValue(new File(this.filePath), this.configData);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                this.configData.put(token, value);
                return;
            }
            current = (Map)current.computeIfAbsent((String)token, k -> new HashMap());
        }
    }

    @Override
    public <T> T getConfigValue(String key, Class<T> type) {
        Map current = this.configData;
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                return type.cast(current.get(token));
            }
            current = (Map)current.get(token);
        }
        return null;
    }

    @Override
    public Map<String, Object> getConfigData() {
        return new HashMap<String, Object>(this.configData);
    }
}

