/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.syntaxjason.annotation.ConfigParam;
import me.syntaxjason.config.IConfigManager;

public class ConfigurationProxy
implements InvocationHandler {
    private IConfigManager configManager;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Set<String> modifiedKeys = new HashSet<String>();
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, Boolean> copyDefaults = new HashMap<String, Boolean>();

    public ConfigurationProxy(IConfigManager configManager, Class<?> configInterface) {
        this.configManager = configManager;
        try {
            this.configManager.loadConfig();
            Map<String, Object> loadedValues = this.configManager.getConfigData();
            for (String key : loadedValues.keySet()) {
                this.values.put(key, loadedValues.get(key));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load configuration", e);
        }
        for (Method method : configInterface.getMethods()) {
            if (!method.isAnnotationPresent(ConfigParam.class)) continue;
            ConfigParam param = method.getAnnotation(ConfigParam.class);
            this.defaults.put(method.getName(), param.defaultValue());
            this.copyDefaults.put(method.getName(), param.copyDefault());
        }
    }

    public static <T> T create(Class<T> configInterface, IConfigManager configManager) {
        return (T)Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)new ConfigurationProxy(configManager, configInterface));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("get") && args == null) {
            String propertyKey = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Object value = this.values.get(propertyKey);
            if (value == null && this.defaults.containsKey(methodName)) {
                if (this.copyDefaults.get(methodName).booleanValue()) {
                    System.out.println(this.copyDefaults.get(methodName));
                    this.values.put(propertyKey, this.defaults.get(methodName));
                    this.saveConfiguration();
                }
                System.out.println(this.copyDefaults.get(methodName));
                return method.getReturnType().cast(this.defaults.get(methodName));
            }
            return this.values.getOrDefault(propertyKey, method.getDefaultValue());
        }
        if (methodName.startsWith("set") && args.length == 1) {
            String propertyKey = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            this.values.put(propertyKey, args[0]);
            return null;
        }
        return method.invoke((Object)this.configManager, args);
    }

    public void saveConfiguration() throws Exception {
        for (String key : this.modifiedKeys) {
            this.configManager.setConfigValue(key, this.values.get(key));
        }
        this.configManager.saveConfig();
        this.modifiedKeys.clear();
    }
}

