/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.io.IOException;
import java.lang.reflect.Proxy;
import me.syntaxjason.ConfigurationProxy;
import me.syntaxjason.annotation.ConfigSource;
import me.syntaxjason.config.IConfigManager;
import me.syntaxjason.config.JsonConfiguration;
import me.syntaxjason.config.TomlConfiguration;
import me.syntaxjason.config.YamlConfiguration;

public class ConfigurationFactory {
    public static <T> T createConfig(Class<T> configClass) throws Exception {
        if (!configClass.isAnnotationPresent(ConfigSource.class)) {
            throw new IllegalArgumentException("Configuration class must have a ConfigSource annotation");
        }
        ConfigSource source = configClass.getAnnotation(ConfigSource.class);
        IConfigManager manager = ConfigurationFactory.getConfigManager(source);
        return ConfigurationProxy.create(configClass, manager);
    }

    public static void saveConfiguration(Object configInstance) {
        try {
            ((ConfigurationProxy)Proxy.getInvocationHandler(configInstance)).saveConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IConfigManager getConfigManager(ConfigSource source) throws IOException {
        switch (source.type()) {
            case JSON: {
                return new JsonConfiguration(source.value());
            }
            case YAML: {
                return new YamlConfiguration(source.value());
            }
            case TOML: {
                return new TomlConfiguration(source.value());
            }
        }
        throw new IllegalArgumentException("Unsupported configuration type: " + source.type().name());
    }
}

