/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import me.syntaxjason.config.IConfigManager;

public class YamlConfiguration
implements IConfigManager {
    private Map<String, Object> configData;
    private YAMLMapper yamlMapper;
    private String filePath;

    public YamlConfiguration(String filePath) throws IOException {
        this.filePath = filePath;
        this.yamlMapper = new YAMLMapper();
        this.loadConfig();
    }

    @Override
    public void loadConfig() throws IOException {
        File configFile = new File(this.filePath);
        this.configData = (Map)this.yamlMapper.readValue(configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public void saveConfig() throws IOException {
        this.yamlMapper.writeValue(new File(this.filePath), this.configData);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        this.configData.put(key, value);
    }
}

