/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import me.syntaxjason.config.IConfigManager;

public class JsonConfiguration
implements IConfigManager {
    private Map<String, Object> configData;
    private ObjectMapper objectMapper;
    private String filePath;

    public JsonConfiguration(String filePath) throws IOException {
        this.filePath = filePath;
        this.objectMapper = new ObjectMapper();
        this.loadConfig();
    }

    @Override
    public void loadConfig() throws IOException {
        File configFile = new File(this.filePath);
        this.configData = (Map)this.objectMapper.readValue(configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public void saveConfig() throws IOException {
        this.objectMapper.writeValue(new File(this.filePath), this.configData);
    }

    @Override
    public void setConfigValue(String key, Object value) {
        this.configData.put(key, value);
    }
}

