/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.syntaxjason.annotation.ConfigParam;
import me.syntaxjason.config.IConfigManager;

public class ConfigurationProxy
implements InvocationHandler {
    private IConfigManager configManager;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Set<String> modifiedKeys = new HashSet<String>();
    private Map<String, String> defaults = new HashMap<String, String>();

    public ConfigurationProxy(IConfigManager configManager, Class<?> configInterface) {
        this.configManager = configManager;
        for (Method method : configInterface.getMethods()) {
            if (!method.isAnnotationPresent(ConfigParam.class)) continue;
            ConfigParam param = method.getAnnotation(ConfigParam.class);
            this.defaults.put(method.getName(), param.defaultValue());
        }
    }

    public static <T> T create(Class<T> configInterface, IConfigManager configManager) {
        return (T)Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)new ConfigurationProxy(configManager, configInterface));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String propertyKey = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        if (methodName.startsWith("get") && args == null) {
            Object value = this.values.get(propertyKey);
            if (value == null && this.defaults.containsKey(methodName)) {
                return method.getReturnType().cast(this.defaults.get(methodName));
            }
            return value;
        }
        if (methodName.startsWith("set") && args.length == 1) {
            this.values.put(propertyKey, args[0]);
            this.modifiedKeys.add(propertyKey);
            return null;
        }
        return method.invoke((Object)this.configManager, args);
    }

    public void saveConfiguration() throws Exception {
        for (String key : this.modifiedKeys) {
            this.configManager.setConfigValue(key, this.values.get(key));
        }
        this.configManager.saveConfig();
        this.modifiedKeys.clear();
    }
}

