/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.value;

import de.syntaxjason.SimpleMinDocument;
import de.syntaxjason.value.SimpleMinArray;
import de.syntaxjason.value.SimpleMinPrimitive;
import de.syntaxjason.value.SimpleMinValue;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleMinObject
implements SimpleMinValue {
    private Map<String, SimpleMinValue> properties = new LinkedHashMap<String, SimpleMinValue>();

    public void put(String key, SimpleMinValue value) {
        this.properties.put(key, value);
    }

    public SimpleMinValue get(String key) {
        SimpleMinValue value = this.properties.get(key);
        return this.resolve(value);
    }

    private SimpleMinValue resolve(SimpleMinValue value) {
        String varName;
        SimpleMinPrimitive varValue;
        String s;
        Object raw;
        if (value instanceof SimpleMinPrimitive && (raw = ((SimpleMinPrimitive)value).getValue()) instanceof String && (s = (String)raw).startsWith("$") && (varValue = SimpleMinDocument.currentVariables.get(varName = s.substring(1))) != null) {
            return new SimpleMinPrimitive(varValue.getValue());
        }
        return value;
    }

    public Map<String, SimpleMinValue> getProperties() {
        return this.properties;
    }

    @Override
    public String serialize(int indent) {
        StringBuilder sb = new StringBuilder();
        String pad = " ".repeat(indent);
        for (Map.Entry<String, SimpleMinValue> entry : this.properties.entrySet()) {
            sb.append(pad).append(entry.getKey());
            SimpleMinValue val = entry.getValue();
            if (val instanceof SimpleMinObject || val instanceof SimpleMinArray) {
                sb.append(":\n").append(val.serialize(indent + 4));
                continue;
            }
            sb.append(" = ").append(val.serialize(0)).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.properties.toString();
    }
}

