/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.value;

import de.syntaxjason.value.SimpleMinObject;
import de.syntaxjason.value.SimpleMinValue;
import java.util.ArrayList;
import java.util.List;

public class SimpleMinArray
implements SimpleMinValue {
    private List<SimpleMinValue> elements = new ArrayList<SimpleMinValue>();

    public SimpleMinArray() {
    }

    public SimpleMinArray(List<SimpleMinValue> simpleMinValues) {
        this.elements.addAll(simpleMinValues);
    }

    public void add(SimpleMinValue value) {
        this.elements.add(value);
    }

    public List<SimpleMinValue> getElements() {
        return this.elements;
    }

    @Override
    public String serialize(int indent) {
        StringBuilder sb = new StringBuilder();
        String pad = " ".repeat(indent);
        for (SimpleMinValue element : this.elements) {
            sb.append(pad).append("- ");
            if (element instanceof SimpleMinObject || element instanceof SimpleMinArray) {
                String serializedChild = element.serialize(0);
                String[] lines = serializedChild.split("\n");
                sb.append(lines[0]).append("\n");
                String subPad = " ".repeat(indent + 2);
                for (int i = 1; i < lines.length; ++i) {
                    sb.append(subPad).append(lines[i]).append("\n");
                }
                continue;
            }
            sb.append(element.serialize(0)).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.elements.toString();
    }
}

