/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason;

import de.syntaxjason.value.SimpleMinArray;
import de.syntaxjason.value.SimpleMinObject;
import de.syntaxjason.value.SimpleMinPrimitive;
import de.syntaxjason.value.SimpleMinValue;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SimpleMinSpigotUtils {
    public static SimpleMinObject itemStackToSimpleMin(ItemStack item) {
        SimpleMinObject obj = new SimpleMinObject();
        if (item == null) {
            return obj;
        }
        if (item.getType() != null) {
            obj.put("material", new SimpleMinPrimitive(item.getType().toString()));
        }
        obj.put("amount", new SimpleMinPrimitive(item.getAmount()));
        if (item.hasItemMeta() && item.getItemMeta() != null) {
            ItemMeta meta = item.getItemMeta();
            SimpleMinObject metaObj = new SimpleMinObject();
            if (meta.hasDisplayName() && meta.getDisplayName() != null) {
                metaObj.put("displayName", new SimpleMinPrimitive(meta.getDisplayName()));
            }
            if (meta.hasLore() && meta.getLore() != null) {
                SimpleMinArray loreArray = new SimpleMinArray();
                for (String string : meta.getLore()) {
                    loreArray.add(new SimpleMinPrimitive(string));
                }
                metaObj.put("lore", loreArray);
            }
            if (!meta.getEnchants().isEmpty()) {
                SimpleMinObject enchantsObj = new SimpleMinObject();
                for (Map.Entry entry : meta.getEnchants().entrySet()) {
                    enchantsObj.put(((Enchantment)entry.getKey()).getName(), new SimpleMinPrimitive(entry.getValue()));
                }
                metaObj.put("enchants", enchantsObj);
            }
            if (!meta.getItemFlags().isEmpty()) {
                SimpleMinArray flagsArray = new SimpleMinArray();
                for (ItemFlag itemFlag : meta.getItemFlags()) {
                    flagsArray.add(new SimpleMinPrimitive(itemFlag.name()));
                }
                metaObj.put("itemFlags", flagsArray);
            }
            if (meta.getItemName() != null && !meta.getItemName().isEmpty()) {
                metaObj.put("localizedName", new SimpleMinPrimitive(meta.getItemName()));
            }
            if (meta.hasCustomModelData()) {
                metaObj.put("customModelData", new SimpleMinPrimitive(meta.getCustomModelData()));
            }
            metaObj.put("unbreakable", new SimpleMinPrimitive(meta.isUnbreakable()));
            if (!meta.getPersistentDataContainer().getKeys().isEmpty()) {
                SimpleMinObject pdcObj = new SimpleMinObject();
                for (NamespacedKey namespacedKey : meta.getPersistentDataContainer().getKeys()) {
                    String value = (String)meta.getPersistentDataContainer().get(namespacedKey, PersistentDataType.STRING);
                    if (value == null) continue;
                    pdcObj.put(namespacedKey.getNamespace() + ":" + namespacedKey.getKey(), new SimpleMinPrimitive(value));
                }
                metaObj.put("persistentData", pdcObj);
            }
            obj.put("meta", metaObj);
        }
        return obj;
    }

    public static ItemStack simpleMinToItemStack(SimpleMinObject obj, Plugin plugin) throws Exception {
        String materialStr = ((SimpleMinPrimitive)obj.get("material")).getValue().toString();
        Material material = Material.valueOf((String)materialStr);
        int amount = Integer.parseInt(((SimpleMinPrimitive)obj.get("amount")).getValue().toString());
        ItemStack item = new ItemStack(material, amount);
        SimpleMinValue metaValue = obj.get("meta");
        if (metaValue != null && metaValue instanceof SimpleMinObject) {
            SimpleMinObject metaObj = (SimpleMinObject)metaValue;
            ItemMeta meta = item.getItemMeta();
            if (metaObj.get("displayName") != null) {
                String displayName = ((SimpleMinPrimitive)metaObj.get("displayName")).getValue().toString();
                meta.setDisplayName(displayName);
            }
            if (metaObj.get("lore") != null && metaObj.get("lore") instanceof SimpleMinArray) {
                SimpleMinArray loreArray = (SimpleMinArray)metaObj.get("lore");
                ArrayList<String> lore = new ArrayList<String>();
                for (SimpleMinValue v : loreArray.getElements()) {
                    lore.add(((SimpleMinPrimitive)v).getValue().toString());
                }
                meta.setLore(lore);
            }
            if (metaObj.get("enchants") != null && metaObj.get("enchants") instanceof SimpleMinObject) {
                SimpleMinObject enchantsObj = (SimpleMinObject)metaObj.get("enchants");
                for (Map.Entry entry : enchantsObj.getProperties().entrySet()) {
                    Enchantment enchantment = Enchantment.getByName((String)((String)entry.getKey()));
                    int level = Integer.parseInt(((SimpleMinPrimitive)entry.getValue()).getValue().toString());
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, level, true);
                }
            }
            if (metaObj.get("itemFlags") != null && metaObj.get("itemFlags") instanceof SimpleMinArray) {
                SimpleMinArray flagsArray = (SimpleMinArray)metaObj.get("itemFlags");
                for (SimpleMinValue simpleMinValue : flagsArray.getElements()) {
                    String flagName = ((SimpleMinPrimitive)simpleMinValue).getValue().toString();
                    try {
                        ItemFlag flag = ItemFlag.valueOf((String)flagName);
                        meta.addItemFlags(new ItemFlag[]{flag});
                    }
                    catch (IllegalArgumentException flag) {}
                }
            }
            if (metaObj.get("localizedName") != null) {
                String localizedName = ((SimpleMinPrimitive)metaObj.get("localizedName")).getValue().toString();
                meta.setItemName(localizedName);
            }
            if (metaObj.get("customModelData") != null) {
                int customModelData = Integer.parseInt(((SimpleMinPrimitive)metaObj.get("customModelData")).getValue().toString());
                meta.setCustomModelData(Integer.valueOf(customModelData));
            }
            if (metaObj.get("unbreakable") != null) {
                boolean unbreakable = Boolean.parseBoolean(((SimpleMinPrimitive)metaObj.get("unbreakable")).getValue().toString());
                meta.setUnbreakable(unbreakable);
            }
            if (metaObj.get("persistentData") != null && metaObj.get("persistentData") instanceof SimpleMinObject) {
                SimpleMinObject pdcObj = (SimpleMinObject)metaObj.get("persistentData");
                for (Map.Entry entry : pdcObj.getProperties().entrySet()) {
                    String keyStr = (String)entry.getKey();
                    String[] parts = keyStr.split(":");
                    if (parts.length != 2) continue;
                    NamespacedKey key = new NamespacedKey(plugin, parts[1]);
                    String value = ((SimpleMinPrimitive)entry.getValue()).getValue().toString();
                    meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static SimpleMinObject locationToSimpleMin(Location loc) {
        SimpleMinObject obj = new SimpleMinObject();
        if (loc == null) {
            return obj;
        }
        obj.put("world", new SimpleMinPrimitive(loc.getWorld().getName()));
        obj.put("x", new SimpleMinPrimitive(loc.getX()));
        obj.put("y", new SimpleMinPrimitive(loc.getY()));
        obj.put("z", new SimpleMinPrimitive(loc.getZ()));
        obj.put("yaw", new SimpleMinPrimitive(Float.valueOf(loc.getYaw())));
        obj.put("pitch", new SimpleMinPrimitive(Float.valueOf(loc.getPitch())));
        return obj;
    }

    public static Location simpleMinToLocation(SimpleMinObject obj) throws Exception {
        String worldName = ((SimpleMinPrimitive)obj.get("world")).getValue().toString();
        double x = Double.parseDouble(((SimpleMinPrimitive)obj.get("x")).getValue().toString());
        double y = Double.parseDouble(((SimpleMinPrimitive)obj.get("y")).getValue().toString());
        double z = Double.parseDouble(((SimpleMinPrimitive)obj.get("z")).getValue().toString());
        float yaw = Float.parseFloat(((SimpleMinPrimitive)obj.get("yaw")).getValue().toString());
        float pitch = Float.parseFloat(((SimpleMinPrimitive)obj.get("pitch")).getValue().toString());
        return new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
    }
}

