/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason;

import de.syntaxjason.value.SimpleMinArray;
import de.syntaxjason.value.SimpleMinObject;
import de.syntaxjason.value.SimpleMinPrimitive;
import de.syntaxjason.value.SimpleMinValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleMinDocument {
    private String path;
    private SimpleMinValue root;
    private Map<String, SimpleMinPrimitive> variables = new LinkedHashMap<String, SimpleMinPrimitive>();
    public static Map<String, SimpleMinPrimitive> currentVariables = new LinkedHashMap<String, SimpleMinPrimitive>();

    public SimpleMinDocument(String path) {
        this.path = path;
        this.load();
        if (this.root == null) {
            this.root = new SimpleMinObject();
        }
        currentVariables = this.variables;
    }

    private void load() {
        Path filePath = Paths.get(this.path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            String content = Files.readString(filePath, StandardCharsets.UTF_8);
            this.parse(content);
        }
        catch (Exception e) {
            System.err.println("Fehler beim Laden der Datei: " + e.getMessage());
        }
    }

    public void save() {
        String content = this.serialize();
        try {
            Files.writeString(Paths.get(this.path, new String[0]), (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Fehler beim Speichern der Datei: " + e.getMessage());
        }
    }

    public SimpleMinValue getRoot() {
        return this.root;
    }

    public void setRoot(SimpleMinValue value) {
        this.root = value;
    }

    public Map<String, SimpleMinPrimitive> getVariables() {
        return this.variables;
    }

    public void setVariable(String name, SimpleMinPrimitive value) {
        this.variables.put(name, value);
        currentVariables.put(name, value);
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, SimpleMinPrimitive> entry : this.variables.entrySet()) {
            sb.append("$").append(entry.getKey()).append(" = ").append(this.quote(entry.getValue().getValue())).append("\n");
        }
        sb.append(this.root.serialize(0));
        return sb.toString();
    }

    private String quote(Object value) {
        if (value instanceof String) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return value.toString();
    }

    private void parse(String content) throws Exception {
        List<String> lines = Arrays.asList(content.split("\\r?\\n"));
        int idx = 0;
        while (idx < lines.size()) {
            String line = lines.get(idx).trim();
            if (line.isEmpty() || line.startsWith("#") || line.startsWith("//")) {
                ++idx;
                continue;
            }
            if (!line.startsWith("$")) break;
            this.parseVariable(line);
            ++idx;
        }
        this.root = this.parseMapping(lines.subList(idx, lines.size()), 0);
    }

    private void parseVariable(String line) throws Exception {
        int eq = line.indexOf("=");
        if (eq < 0) {
            throw new Exception("Ung\u00fcltige Variablendeklaration: " + line);
        }
        String key = line.substring(1, eq).trim();
        String token = line.substring(eq + 1).trim();
        Object value = this.parsePrimitive(token);
        this.variables.put(key, new SimpleMinPrimitive(value));
    }

    private SimpleMinObject parseMapping(List<String> lines, int baseIndent) throws Exception {
        SimpleMinObject obj = new SimpleMinObject();
        int idx = 0;
        while (idx < lines.size()) {
            String line = lines.get(idx);
            if (line.trim().isEmpty() || line.trim().startsWith("#") || line.trim().startsWith("//")) {
                ++idx;
                continue;
            }
            int indent = this.countIndent(line);
            if (indent < baseIndent) break;
            String trimmed = line.trim();
            if (trimmed.endsWith(":")) {
                String key = trimmed.substring(0, trimmed.length() - 1).trim();
                ++idx;
                ArrayList<String> subLines = new ArrayList<String>();
                while (idx < lines.size() && this.countIndent(lines.get(idx)) >= baseIndent + 4) {
                    subLines.add(lines.get(idx));
                    ++idx;
                }
                if (!subLines.isEmpty() && ((String)subLines.get(0)).trim().startsWith("-")) {
                    obj.put(key, new SimpleMinArray(this.parseArray(subLines, baseIndent + 4)));
                    continue;
                }
                obj.put(key, this.parseMapping(subLines, baseIndent + 4));
                continue;
            }
            if (trimmed.contains("=")) {
                int eqPos = trimmed.indexOf("=");
                String key = trimmed.substring(0, eqPos).trim();
                String token = trimmed.substring(eqPos + 1).trim();
                obj.put(key, new SimpleMinPrimitive(this.parsePrimitive(token)));
                ++idx;
                continue;
            }
            ++idx;
        }
        return obj;
    }

    private List<SimpleMinValue> parseArray(List<String> lines, int baseIndent) throws Exception {
        ArrayList<SimpleMinValue> list = new ArrayList<SimpleMinValue>();
        int idx = 0;
        while (idx < lines.size()) {
            String single;
            String line = lines.get(idx);
            if (line.trim().isEmpty() || line.trim().startsWith("#") || line.trim().startsWith("//")) {
                ++idx;
                continue;
            }
            int indent = this.countIndent(line);
            if (indent < baseIndent) break;
            String trimmed = line.trim();
            if (!trimmed.startsWith("-")) {
                ++idx;
                continue;
            }
            int dashIndent = indent;
            String inlineContent = trimmed.substring(1).trim();
            ArrayList<String> elementBlock = new ArrayList<String>();
            if (!inlineContent.isEmpty()) {
                elementBlock.add(inlineContent);
            }
            ++idx;
            while (idx < lines.size()) {
                String nextLine = lines.get(idx);
                if (nextLine.trim().isEmpty() || nextLine.trim().startsWith("#") || nextLine.trim().startsWith("//")) {
                    ++idx;
                    continue;
                }
                int nextIndent = this.countIndent(nextLine);
                if (nextIndent <= dashIndent) break;
                elementBlock.add(nextLine.substring(dashIndent));
                ++idx;
            }
            SimpleMinValue elementValue = elementBlock.size() == 1 ? ((single = (String)elementBlock.get(0)).contains("=") || single.endsWith(":") ? this.parseMapping(elementBlock, dashIndent + 2) : new SimpleMinPrimitive(this.parsePrimitive(single))) : this.parseMapping(elementBlock, dashIndent + 2);
            list.add(elementValue);
        }
        return list;
    }

    private Object parsePrimitive(String token) {
        if (token.startsWith("\"") && token.endsWith("\"") && token.length() >= 2) {
            return token.substring(1, token.length() - 1);
        }
        if ("true".equalsIgnoreCase(token) || "false".equalsIgnoreCase(token)) {
            return Boolean.parseBoolean(token);
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(token);
            }
            catch (NumberFormatException numberFormatException2) {
                String var;
                if (token.startsWith("$") && this.variables.containsKey(var = token.substring(1))) {
                    return this.variables.get(var).getValue();
                }
                return token;
            }
        }
    }

    private int countIndent(String line) {
        int count = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++count;
        }
        return count;
    }

    public String getPath() {
        return this.path;
    }
}

