/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import net.byteunion.JsonArray;
import net.byteunion.JsonBoolean;
import net.byteunion.JsonError;
import net.byteunion.JsonNull;
import net.byteunion.JsonNumber;
import net.byteunion.JsonObject;
import net.byteunion.JsonString;
import net.byteunion.JsonValue;
import net.byteunion.io.JsonReader;
import net.byteunion.io.Token;

public final class JsonTree {
    private JsonTree() {
    }

    public static JsonValue parse(String s) {
        JsonValue jsonValue;
        JsonReader r = new JsonReader(s);
        try {
            jsonValue = new Parser(r).parse();
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JsonError(e.getMessage(), 0L, 0L);
            }
        }
        r.close();
        return jsonValue;
    }

    public static JsonValue parse(InputStream in) {
        JsonValue jsonValue;
        JsonReader r = new JsonReader(in);
        try {
            jsonValue = new Parser(r).parse();
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JsonError(e.getMessage(), 0L, 0L);
            }
        }
        r.close();
        return jsonValue;
    }

    private static final class Parser {
        private final JsonReader r;
        private Token t;

        Parser(JsonReader r) throws IOException {
            this.r = r;
            this.t = r.next();
        }

        JsonValue parse() throws IOException {
            JsonValue v = this.value();
            if (this.t != Token.EOF) {
                throw this.err("Trailing input");
            }
            return v;
        }

        private JsonValue value() throws IOException {
            return switch (this.t) {
                case Token.LBRACE -> this.object();
                case Token.LBRACK -> this.array();
                case Token.STRING -> {
                    String s = this.r.string();
                    this.next();
                    yield new JsonString(s);
                }
                case Token.NUMBER -> {
                    BigDecimal n = this.r.number();
                    this.next();
                    yield new JsonNumber(n);
                }
                case Token.TRUE -> {
                    this.next();
                    yield JsonBoolean.TRUE;
                }
                case Token.FALSE -> {
                    this.next();
                    yield JsonBoolean.FALSE;
                }
                case Token.NULL -> {
                    this.next();
                    yield JsonNull.NULL;
                }
                default -> throw this.err("Value expected");
            };
        }

        private JsonObject object() throws IOException {
            this.next();
            JsonObject obj = new JsonObject();
            if (this.t == Token.RBRACE) {
                this.next();
                return obj;
            }
            while (true) {
                if (this.t != Token.STRING) {
                    throw this.err("String key expected");
                }
                String key = this.r.string();
                this.next();
                if (this.t != Token.COLON) {
                    throw this.err("':' expected");
                }
                this.next();
                JsonValue val = this.value();
                obj.put(key, val);
                if (this.t != Token.COMMA) break;
                this.next();
            }
            if (this.t == Token.RBRACE) {
                this.next();
                return obj;
            }
            throw this.err("',' or '}' expected");
        }

        private JsonArray array() throws IOException {
            this.next();
            JsonArray arr = new JsonArray();
            if (this.t == Token.RBRACK) {
                this.next();
                return arr;
            }
            while (true) {
                JsonValue v = this.value();
                arr.add(v);
                if (this.t != Token.COMMA) break;
                this.next();
            }
            if (this.t == Token.RBRACK) {
                this.next();
                return arr;
            }
            throw this.err("',' or ']' expected");
        }

        private void next() throws IOException {
            this.t = this.r.next();
        }

        private JsonError err(String msg) {
            return new JsonError(msg, 0L, 0L);
        }
    }
}

