/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.io;

import java.io.IOException;
import java.math.BigDecimal;
import net.byteunion.JsonError;
import net.byteunion.io.CharSource;
import net.byteunion.io.Token;

public final class JsonLexer {
    private final CharSource cs;
    String string;
    BigDecimal number;
    Token token = Token.EOF;

    JsonLexer(CharSource cs) {
        this.cs = cs;
    }

    public Token nextToken() throws IOException {
        int c;
        while (true) {
            if ((c = this.cs.peek()) == -1) {
                this.token = Token.EOF;
                return this.token;
            }
            if (!JsonLexer.isWs(c)) break;
            this.cs.next();
        }
        switch (c) {
            case 123: {
                this.cs.next();
                this.token = Token.LBRACE;
                return this.token;
            }
            case 125: {
                this.cs.next();
                this.token = Token.RBRACE;
                return this.token;
            }
            case 91: {
                this.cs.next();
                this.token = Token.LBRACK;
                return this.token;
            }
            case 93: {
                this.cs.next();
                this.token = Token.RBRACK;
                return this.token;
            }
            case 58: {
                this.cs.next();
                this.token = Token.COLON;
                return this.token;
            }
            case 44: {
                this.cs.next();
                this.token = Token.COMMA;
                return this.token;
            }
            case 34: {
                this.string = this.readString();
                this.token = Token.STRING;
                return this.token;
            }
            case 116: {
                this.readWord("true");
                this.token = Token.TRUE;
                return this.token;
            }
            case 102: {
                this.readWord("false");
                this.token = Token.FALSE;
                return this.token;
            }
            case 110: {
                this.readWord("null");
                this.token = Token.NULL;
                return this.token;
            }
        }
        if (c == 45 || c == 46 || JsonLexer.isDigit(c)) {
            this.number = this.readNumber();
            this.token = Token.NUMBER;
            return this.token;
        }
        throw this.err("Unexpected char '" + (char)c + "'");
    }

    private String readString() throws IOException {
        if (this.cs.next() != 34) {
            throw this.err("String must start with quote");
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.cs.next()) == -1) {
                throw this.err("Unterminated string");
            }
            if (c == 34) {
                return sb.toString();
            }
            if (c == 92) {
                int e = this.cs.next();
                switch (e) {
                    case 34: {
                        sb.append('\"');
                        break;
                    }
                    case 92: {
                        sb.append('\\');
                        break;
                    }
                    case 47: {
                        sb.append('/');
                        break;
                    }
                    case 98: {
                        sb.append('\b');
                        break;
                    }
                    case 102: {
                        sb.append('\f');
                        break;
                    }
                    case 110: {
                        sb.append('\n');
                        break;
                    }
                    case 114: {
                        sb.append('\r');
                        break;
                    }
                    case 116: {
                        sb.append('\t');
                        break;
                    }
                    case 117: {
                        int u = JsonLexer.hex(this.cs.next()) << 12 | JsonLexer.hex(this.cs.next()) << 8 | JsonLexer.hex(this.cs.next()) << 4 | JsonLexer.hex(this.cs.next());
                        sb.append((char)u);
                        break;
                    }
                    default: {
                        throw this.err("Illegal escape: \\" + (char)e);
                    }
                }
                continue;
            }
            if (c < 32) {
                throw this.err("Control char in string");
            }
            sb.append((char)c);
        }
    }

    private void readWord(String w) throws IOException {
        for (int i = 0; i < w.length(); ++i) {
            int c = this.cs.next();
            if (c == w.charAt(i)) continue;
            throw this.err("Expected '" + w + "'");
        }
    }

    private BigDecimal readNumber() throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = this.cs.peek();
        if (c == 45) {
            sb.append((char)this.cs.next());
            c = this.cs.peek();
        }
        if (!JsonLexer.isDigit(c)) {
            throw this.err("Digit expected");
        }
        if (c == 48) {
            sb.append((char)this.cs.next());
        } else {
            while (JsonLexer.isDigit(this.cs.peek())) {
                sb.append((char)this.cs.next());
            }
        }
        if (this.cs.peek() == 46) {
            sb.append((char)this.cs.next());
            if (!JsonLexer.isDigit(this.cs.peek())) {
                throw this.err("Digit expected after dot");
            }
            while (JsonLexer.isDigit(this.cs.peek())) {
                sb.append((char)this.cs.next());
            }
        }
        if ((c = this.cs.peek()) == 101 || c == 69) {
            sb.append((char)this.cs.next());
            if (this.cs.peek() == 43 || this.cs.peek() == 45) {
                sb.append((char)this.cs.next());
            }
            if (!JsonLexer.isDigit(this.cs.peek())) {
                throw this.err("Digit expected in exponent");
            }
            while (JsonLexer.isDigit(this.cs.peek())) {
                sb.append((char)this.cs.next());
            }
        }
        return new BigDecimal(sb.toString());
    }

    private static boolean isWs(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static int hex(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return 10 + (c - 97);
        }
        if (c >= 65 && c <= 70) {
            return 10 + (c - 65);
        }
        throw new IllegalArgumentException("Bad hex " + (char)c);
    }

    private JsonError err(String m) {
        return new JsonError(m, this.cs.line, this.cs.col);
    }
}

