/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public final class CharSource
implements Closeable {
    private final Reader in;
    private final char[] buf = new char[4096];
    private int p = 0;
    private int n = 0;
    public long line = 1L;
    public long col = 0L;

    CharSource(Reader in) {
        this.in = in;
    }

    public static CharSource of(InputStream in) {
        return new CharSource(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public static CharSource of(String s) {
        return new CharSource(new StringReader(s));
    }

    public int peek() throws IOException {
        if (this.p >= this.n) {
            this.n = this.in.read(this.buf);
            this.p = 0;
            if (this.n <= 0) {
                return -1;
            }
        }
        return this.buf[this.p];
    }

    public int next() throws IOException {
        int c = this.peek();
        if (c == -1) {
            return -1;
        }
        ++this.p;
        if (c == 10) {
            ++this.line;
            this.col = 0L;
        } else {
            ++this.col;
        }
        return c;
    }

    public void skipBom() throws IOException {
        if (this.peek() == 65279) {
            this.next();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

