/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config;

import java.util.Map;
import net.byteunion.JsonArray;
import net.byteunion.JsonNull;
import net.byteunion.JsonObject;
import net.byteunion.JsonValue;

public final class JsonMerge {
    private JsonMerge() {
    }

    public static JsonValue deepMerge(JsonValue left, JsonValue right) {
        if (right == null || right instanceof JsonNull) {
            return left;
        }
        if (left == null || left instanceof JsonNull) {
            return right;
        }
        if (left instanceof JsonObject) {
            JsonObject lo = (JsonObject)left;
            if (right instanceof JsonObject) {
                JsonObject ro = (JsonObject)right;
                JsonObject out = new JsonObject();
                for (Map.Entry<String, JsonValue> e : lo) {
                    out.put(e.getKey(), e.getValue());
                }
                for (Map.Entry<String, JsonValue> e : ro) {
                    String k = e.getKey();
                    out.put(k, JsonMerge.deepMerge(lo.get(k), e.getValue()));
                }
                return out;
            }
        }
        if (left instanceof JsonArray) {
            JsonArray la = (JsonArray)left;
            if (right instanceof JsonArray) {
                JsonArray ra = (JsonArray)right;
                return ra;
            }
        }
        return right;
    }
}

