/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.byteunion.Json;
import net.byteunion.JsonArray;
import net.byteunion.JsonBoolean;
import net.byteunion.JsonNull;
import net.byteunion.JsonNumber;
import net.byteunion.JsonObject;
import net.byteunion.JsonString;
import net.byteunion.JsonValue;
import net.byteunion.config.annotations.ConfDefault;
import net.byteunion.config.annotations.ConfKey;

public final class JsonBind {
    private JsonBind() {
    }

    public static JsonValue toJson(Object obj) {
        if (obj == null) {
            return JsonNull.NULL;
        }
        Class<?> type = obj.getClass();
        if (obj instanceof String) {
            String s = (String)obj;
            return new JsonString(s);
        }
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return b != false ? JsonBoolean.TRUE : JsonBoolean.FALSE;
        }
        if (obj instanceof Number) {
            Number n = (Number)obj;
            return new JsonNumber(new BigDecimal(n.toString()));
        }
        if (type.isEnum()) {
            return new JsonString(((Enum)obj).name());
        }
        if (type.isArray()) {
            return JsonBind.toJsonArrayFromArray(obj);
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            return JsonBind.toJsonArrayFromCollection(col);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return JsonBind.toJsonFromMap(map);
        }
        if (type.isRecord()) {
            return JsonBind.toJsonFromRecord(obj);
        }
        return JsonBind.toJsonFromPojo(obj);
    }

    public static <T> T fromJson(JsonValue val, Class<T> type) {
        if (val == null || val instanceof JsonNull) {
            return null;
        }
        if (type == String.class) {
            String string;
            if (val instanceof JsonString) {
                JsonString s = (JsonString)val;
                string = s.value();
            } else {
                string = String.valueOf(JsonBind.raw(val));
            }
            return (T)string;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)JsonBind.castBoolean(val);
        }
        if (Number.class.isAssignableFrom(type) || JsonBind.isPrimitiveNumber(type)) {
            return (T)JsonBind.castNumber(val, type);
        }
        if (type.isEnum()) {
            return (T)Enum.valueOf(type.asSubclass(Enum.class), JsonBind.str(val));
        }
        if (type.isArray()) {
            return (T)JsonBind.arrayFromJson(val, type.getComponentType());
        }
        if (Collection.class.isAssignableFrom(type)) {
            return (T)JsonBind.collectionFromJson(val, type);
        }
        if (Map.class.isAssignableFrom(type)) {
            return (T)JsonBind.mapFromJson(val, type);
        }
        if (type.isRecord()) {
            return JsonBind.recordFromJson(val, type);
        }
        return JsonBind.pojoFromJson(val, type);
    }

    private static JsonArray toJsonArrayFromArray(Object array) {
        int len = Array.getLength(array);
        JsonArray out = new JsonArray();
        for (int i = 0; i < len; ++i) {
            out.add(JsonBind.toJson(Array.get(array, i)));
        }
        return out;
    }

    private static JsonArray toJsonArrayFromCollection(Collection<?> col) {
        JsonArray out = new JsonArray();
        for (Object o : col) {
            out.add(JsonBind.toJson(o));
        }
        return out;
    }

    private static JsonValue toJsonFromMap(Map<?, ?> map) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            obj.put(String.valueOf(e.getKey()), JsonBind.toJson(e.getValue()));
        }
        return obj;
    }

    private static JsonValue toJsonFromRecord(Object obj) {
        RecordComponent[] comps;
        JsonObject out = new JsonObject();
        for (RecordComponent rc : comps = obj.getClass().getRecordComponents()) {
            String key = JsonBind.keyName(rc.getName(), rc.getAnnotatedType(), rc.getDeclaredAnnotations());
            try {
                Object v = rc.getAccessor().invoke(obj, new Object[0]);
                out.put(key, JsonBind.toJson(v));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return out;
    }

    private static JsonValue toJsonFromPojo(Object obj) {
        JsonObject out = new JsonObject();
        for (Field f : obj.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            String key = JsonBind.keyName(f.getName(), f.getAnnotatedType(), f.getAnnotations());
            try {
                out.put(key, JsonBind.toJson(f.get(obj)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return out;
    }

    private static <T> T recordFromJson(JsonValue val, Class<T> type) {
        if (!(val instanceof JsonObject)) {
            throw new IllegalArgumentException("Expected object for " + String.valueOf(type));
        }
        JsonObject obj = (JsonObject)val;
        RecordComponent[] comps = type.getRecordComponents();
        Object[] args = new Object[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            RecordComponent rc = comps[i];
            String key = JsonBind.keyName(rc.getName(), rc.getAnnotatedType(), rc.getDeclaredAnnotations());
            JsonValue v = obj.get(key);
            if (v == null) {
                v = JsonBind.defaultFromAnnotation(rc.getDeclaredAnnotations());
            }
            args[i] = JsonBind.convert(v, rc.getGenericType());
        }
        try {
            Class[] ptypes = (Class[])Arrays.stream(comps).map(RecordComponent::getType).toArray(Class[]::new);
            Constructor<T> ctor = type.getDeclaredConstructor(ptypes);
            ctor.setAccessible(true);
            return type.cast(ctor.newInstance(args));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T pojoFromJson(JsonValue val, Class<T> type) {
        if (!(val instanceof JsonObject)) {
            throw new IllegalArgumentException("Expected object for " + String.valueOf(type));
        }
        JsonObject obj = (JsonObject)val;
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            T inst = type.cast(ctor.newInstance(new Object[0]));
            for (Field f : type.getDeclaredFields()) {
                Object converted;
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                String key = JsonBind.keyName(f.getName(), f.getAnnotatedType(), f.getAnnotations());
                JsonValue v = obj.get(key);
                if (v == null) {
                    v = JsonBind.defaultFromAnnotation(f.getAnnotations());
                }
                if ((converted = JsonBind.convert(v, f.getGenericType())) == null) continue;
                f.set(inst, converted);
            }
            return inst;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Object convert(JsonValue v, Type t) {
        if (v == null || v instanceof JsonNull) {
            return null;
        }
        if (t instanceof Class) {
            Class cls = (Class)t;
            return JsonBind.fromJson(v, cls);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Class raw = (Class)pt.getRawType();
            if (Collection.class.isAssignableFrom(raw)) {
                Type elem = pt.getActualTypeArguments()[0];
                ArrayList<Object> out = new ArrayList<Object>();
                if (v instanceof JsonArray) {
                    JsonArray a = (JsonArray)v;
                    for (JsonValue ev : a) {
                        out.add(JsonBind.convert(ev, elem));
                    }
                }
                if (raw.isAssignableFrom(List.class)) {
                    return out;
                }
                if (raw.isAssignableFrom(Set.class)) {
                    return new LinkedHashSet(out);
                }
                return out;
            }
            if (Map.class.isAssignableFrom(raw)) {
                Class kk;
                Type k = pt.getActualTypeArguments()[0];
                Type val = pt.getActualTypeArguments()[1];
                if (!(k instanceof Class) || (kk = (Class)k) != String.class) {
                    throw new IllegalArgumentException("Only Map<String,?> supported");
                }
                LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
                if (v instanceof JsonObject) {
                    JsonObject o = (JsonObject)v;
                    for (Map.Entry<String, JsonValue> e : o) {
                        out.put(e.getKey(), JsonBind.convert(e.getValue(), val));
                    }
                }
                return out;
            }
        }
        return JsonBind.str(v);
    }

    private static Object arrayFromJson(JsonValue v, Class<?> component) {
        if (!(v instanceof JsonArray)) {
            return Array.newInstance(component, 0);
        }
        JsonArray a = (JsonArray)v;
        Object arr = Array.newInstance(component, a.size());
        for (int i = 0; i < a.size(); ++i) {
            Array.set(arr, i, JsonBind.fromJson(a.get(i), component));
        }
        return arr;
    }

    private static Collection<?> collectionFromJson(JsonValue v, Class<?> raw) {
        ArrayList<Object> out = new ArrayList<Object>();
        if (v instanceof JsonArray) {
            JsonArray a = (JsonArray)v;
            for (JsonValue ev : a) {
                out.add(JsonBind.raw(ev));
            }
        }
        if (raw.isAssignableFrom(List.class)) {
            return out;
        }
        if (raw.isAssignableFrom(Set.class)) {
            return new LinkedHashSet(out);
        }
        return out;
    }

    private static Map<?, ?> mapFromJson(JsonValue v, Class<?> raw) {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        if (v instanceof JsonObject) {
            JsonObject o = (JsonObject)v;
            for (Map.Entry<String, JsonValue> e : o) {
                out.put(e.getKey(), JsonBind.raw(e.getValue()));
            }
        }
        return out;
    }

    private static String keyName(String fallback, AnnotatedType at, Annotation[] anns) {
        for (Annotation a : anns) {
            if (!(a instanceof ConfKey)) continue;
            ConfKey ck = (ConfKey)a;
            return ck.value();
        }
        return fallback;
    }

    private static JsonValue defaultFromAnnotation(Annotation[] anns) {
        for (Annotation a : anns) {
            if (!(a instanceof ConfDefault)) continue;
            ConfDefault d = (ConfDefault)a;
            return Json.parse(d.json());
        }
        return null;
    }

    private static Object castNumber(JsonValue v, Class<?> type) {
        if (v instanceof JsonNumber) {
            JsonNumber n = (JsonNumber)v;
            BigDecimal bd = n.value();
            if (type == Integer.TYPE || type == Integer.class) {
                return bd.intValue();
            }
            if (type == Long.TYPE || type == Long.class) {
                return bd.longValue();
            }
            if (type == Double.TYPE || type == Double.class) {
                return bd.doubleValue();
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(bd.floatValue());
            }
            if (type == Short.TYPE || type == Short.class) {
                return bd.shortValue();
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return bd.byteValue();
            }
        }
        try {
            String s = JsonBind.str(v);
            if (type == Integer.TYPE || type == Integer.class) {
                return Integer.parseInt(s);
            }
            if (type == Long.TYPE || type == Long.class) {
                return Long.parseLong(s);
            }
            if (type == Double.TYPE || type == Double.class) {
                return Double.parseDouble(s);
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(Float.parseFloat(s));
            }
            if (type == Short.TYPE || type == Short.class) {
                return Short.parseShort(s);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return Byte.parseByte(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static Boolean castBoolean(JsonValue v) {
        if (v instanceof JsonBoolean) {
            JsonBoolean b = (JsonBoolean)v;
            return b.value();
        }
        return Boolean.parseBoolean(JsonBind.str(v));
    }

    private static boolean isPrimitiveNumber(Class<?> c) {
        return c == Integer.TYPE || c == Long.TYPE || c == Double.TYPE || c == Float.TYPE || c == Short.TYPE || c == Byte.TYPE;
    }

    private static Object raw(JsonValue v) {
        if (v instanceof JsonString) {
            JsonString s = (JsonString)v;
            return s.value();
        }
        if (v instanceof JsonNumber) {
            JsonNumber n = (JsonNumber)v;
            return n.value();
        }
        if (v instanceof JsonBoolean) {
            JsonBoolean b = (JsonBoolean)v;
            return b.value();
        }
        if (v instanceof JsonNull) {
            return null;
        }
        return v;
    }

    private static String str(JsonValue v) {
        if (v instanceof JsonString) {
            JsonString s = (JsonString)v;
            return s.value();
        }
        if (v instanceof JsonNumber) {
            JsonNumber n = (JsonNumber)v;
            return n.value().toPlainString();
        }
        if (v instanceof JsonBoolean) {
            JsonBoolean b = (JsonBoolean)v;
            return String.valueOf(b.value());
        }
        return String.valueOf(v);
    }
}

