/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config;

import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;
import net.byteunion.JsonBoolean;
import net.byteunion.JsonNull;
import net.byteunion.JsonNumber;
import net.byteunion.JsonObject;
import net.byteunion.JsonString;
import net.byteunion.JsonValue;

public final class EnvOverrides {
    private static final Pattern DOT_SPLIT = Pattern.compile("\\.");

    private EnvOverrides() {
    }

    public static void apply(JsonObject root, String envPrefix) {
        EnvOverrides.apply(root, envPrefix, null);
    }

    public static void apply(JsonObject root, String envPrefix, String propPrefix) {
        if (root == null) {
            return;
        }
        if (propPrefix != null && !propPrefix.isBlank()) {
            for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
                String k = String.valueOf(e.getKey());
                if (!k.startsWith(propPrefix)) continue;
                String tail = k.substring(propPrefix.length());
                EnvOverrides.setByDottedKey(root, tail, String.valueOf(e.getValue()));
            }
        }
        if (envPrefix != null && !envPrefix.isBlank()) {
            String p = envPrefix + "__";
            for (Map.Entry<String, String> e : System.getenv().entrySet()) {
                String k = e.getKey();
                if (!k.startsWith(p)) continue;
                String dotted = k.substring(p.length()).toLowerCase().replace("__", ".");
                EnvOverrides.setByDottedKey(root, dotted, e.getValue());
            }
        }
    }

    private static void setByDottedKey(JsonObject root, String dotted, String rawValue) {
        String[] parts = DOT_SPLIT.split(dotted);
        JsonObject cur = root;
        for (int i = 0; i < parts.length; ++i) {
            JsonObject jo;
            JsonObject next;
            String key = parts[i];
            if (i == parts.length - 1) {
                cur.put(key, EnvOverrides.parseScalar(rawValue));
                continue;
            }
            JsonValue existing = cur.get(key);
            JsonObject jsonObject = next = existing instanceof JsonObject ? (jo = (JsonObject)existing) : new JsonObject();
            if (!(existing instanceof JsonObject)) {
                cur.put(key, next);
            }
            cur = next;
        }
    }

    private static JsonValue parseScalar(String s) {
        if (s == null) {
            return JsonNull.NULL;
        }
        String t = s.trim();
        if (t.equalsIgnoreCase("true")) {
            return JsonBoolean.TRUE;
        }
        if (t.equalsIgnoreCase("false")) {
            return JsonBoolean.FALSE;
        }
        try {
            if (t.contains(".") || t.contains("e") || t.contains("E")) {
                return new JsonNumber(new BigDecimal(t));
            }
            long v = Long.parseLong(t);
            return new JsonNumber(new BigDecimal(v));
        }
        catch (Exception exception) {
            return new JsonString(s);
        }
    }
}

