/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.util;

import java.util.Optional;

public final class Ref<E> {
    private E value;
    private boolean locked = false;

    private Ref(E value) {
        this.value = value;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public E get() {
        return this.value;
    }

    public Ref<E> set(E value) {
        if (!this.locked) {
            this.value = value;
        }
        return this;
    }

    public Ref<E> lock() {
        this.locked = true;
        return this;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Optional<E> asOptional() {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }

    public static <E> Ref<E> of() {
        return new Ref<Object>(null);
    }

    public static <E> Ref<E> of(E value) {
        return new Ref<E>(value);
    }
}

