/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.byteunion.JsonArray;
import net.byteunion.JsonBoolean;
import net.byteunion.JsonNull;
import net.byteunion.JsonNumber;
import net.byteunion.JsonObject;
import net.byteunion.JsonString;
import net.byteunion.JsonValue;

public final class JsonWriter {
    private final Appendable out;
    private final boolean prettyPrint;
    private final int indent;
    private int depth = 0;

    private JsonWriter(Appendable out, boolean prettyPrint, int indent) {
        this.out = out;
        this.prettyPrint = prettyPrint;
        this.indent = Math.max(0, indent);
    }

    public static String stringify(JsonValue v) {
        StringBuilder sb = new StringBuilder();
        try {
            new JsonWriter(sb, false, 0).writeValue(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static String pretty(JsonValue v) {
        StringBuilder sb = new StringBuilder();
        try {
            new JsonWriter(sb, true, 2).writeValue(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static byte[] bytes(JsonValue v) {
        return JsonWriter.stringify(v).getBytes(StandardCharsets.UTF_8);
    }

    private void writeValue(JsonValue v) throws IOException {
        if (v == null || v instanceof JsonNull) {
            this.out.append("null");
            return;
        }
        if (v instanceof JsonBoolean) {
            JsonBoolean b = (JsonBoolean)v;
            this.out.append(b.value() ? "true" : "false");
            return;
        }
        if (v instanceof JsonNumber) {
            JsonNumber n = (JsonNumber)v;
            this.out.append(n.value().toPlainString());
            return;
        }
        if (v instanceof JsonString) {
            JsonString s = (JsonString)v;
            this.writeString(s.value());
            return;
        }
        if (v instanceof JsonArray) {
            JsonArray a = (JsonArray)v;
            this.writeArray(a);
            return;
        }
        if (v instanceof JsonObject) {
            JsonObject o = (JsonObject)v;
            this.writeObject(o);
            return;
        }
        throw new IllegalStateException("Unknown JsonValue: " + String.valueOf(v.getClass()));
    }

    private void writeObject(JsonObject obj) throws IOException {
        this.out.append('{');
        if (obj.size() == 0) {
            this.out.append('}');
            return;
        }
        ++this.depth;
        this.nl();
        boolean first = true;
        for (Map.Entry<String, JsonValue> e : obj) {
            if (!first) {
                this.out.append(',');
                this.nl();
            }
            this.indent();
            this.writeString(e.getKey());
            this.out.append(':');
            if (this.prettyPrint) {
                this.out.append(' ');
            }
            this.writeValue(e.getValue());
            first = false;
        }
        this.nl();
        --this.depth;
        this.indent();
        this.out.append('}');
    }

    private void writeArray(JsonArray arr) throws IOException {
        this.out.append('[');
        if (arr.size() == 0) {
            this.out.append(']');
            return;
        }
        ++this.depth;
        this.nl();
        boolean first = true;
        for (JsonValue v : arr) {
            if (!first) {
                this.out.append(',');
                this.nl();
            }
            this.indent();
            this.writeValue(v);
            first = false;
        }
        this.nl();
        --this.depth;
        this.indent();
        this.out.append(']');
    }

    private void writeString(String s) throws IOException {
        this.out.append('\"');
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    this.out.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    this.out.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    this.out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    this.out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    this.out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    this.out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        this.out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    this.out.append(c);
                }
            }
        }
        this.out.append('\"');
    }

    private void nl() throws IOException {
        if (this.prettyPrint) {
            this.out.append('\n');
        }
    }

    private void indent() throws IOException {
        if (this.prettyPrint) {
            this.out.append(" ".repeat(this.indent * this.depth));
        }
    }
}

