/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import net.byteunion.io.CharSource;
import net.byteunion.io.JsonLexer;
import net.byteunion.io.Token;

public final class JsonReader
implements Closeable {
    private final CharSource cs;
    private final JsonLexer lx;

    public JsonReader(InputStream in) {
        this.cs = CharSource.of(in);
        try {
            this.cs.skipBom();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lx = new JsonLexer(this.cs);
    }

    public JsonReader(String s) {
        this.cs = CharSource.of(s);
        this.lx = new JsonLexer(this.cs);
    }

    public Token next() throws IOException {
        return this.lx.nextToken();
    }

    public Token token() {
        return this.lx.token;
    }

    public String string() {
        return this.lx.string;
    }

    public BigDecimal number() {
        return this.lx.number;
    }

    @Override
    public void close() throws IOException {
        this.cs.close();
    }
}

