/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config.mutable;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.byteunion.config.mutable.ByteHandle;
import net.byteunion.util.Ref;

public final class ByteHandles {
    private static final Ref<ByteHandles> INSTANCE = Ref.of();
    private final Map<String, Entry> map = new LinkedHashMap<String, Entry>();
    private String activeName;

    public static Optional<ByteHandles> instance() {
        return INSTANCE.asOptional();
    }

    public ByteHandles() {
        INSTANCE.set(this);
    }

    public <T> ByteHandles add(String name, Path path, Class<T> modelType, Supplier<T> defaults, String envPrefix) throws IOException {
        Objects.requireNonNull(name, "name");
        ByteHandle<T> h = ByteHandle.loadOrCreate(path, modelType, defaults, envPrefix);
        this.map.put(name, new Entry(name, modelType, h));
        if (this.activeName == null) {
            this.activeName = name;
        }
        INSTANCE.set(this);
        return this;
    }

    public ByteHandles use(String name) {
        this.require(name);
        this.activeName = name;
        INSTANCE.set(this);
        return this;
    }

    public String activeName() {
        return this.activeName;
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public <T> ByteHandle<T> handle(String name, Class<T> modelType) {
        Entry e = this.require(name);
        if (!e.type.equals(modelType)) {
            throw new IllegalArgumentException("Config '" + name + "' has type " + e.type.getName() + " not " + modelType.getName());
        }
        return e.handle;
    }

    public <T> T model(String name, Class<T> modelType) {
        return this.handle(name, modelType).model();
    }

    public <T> T model(Class<T> modelType) {
        return this.handle(this.activeName(), modelType).model();
    }

    public ByteHandle.Node root() {
        return this.current().rootNode();
    }

    public ByteHandle.Node section(String name) {
        return this.current().section(name);
    }

    public ByteHandle.Node at(String dotted) {
        return this.current().at(dotted);
    }

    public void save() throws IOException {
        this.current().save();
    }

    public void save(String name) throws IOException {
        this.handleRaw(name).save();
    }

    public void saveAll() throws IOException {
        for (Entry e : this.map.values()) {
            e.handle.save();
        }
    }

    private Entry require(String name) {
        Entry e = this.map.get(name);
        if (e == null) {
            throw new IllegalArgumentException("Unknown config name: " + name + " (known: " + String.valueOf(this.map.keySet()) + ")");
        }
        return e;
    }

    private ByteHandle<?> handleRaw(String name) {
        return this.require((String)name).handle;
    }

    private ByteHandle<?> current() {
        return this.handleRaw(this.activeName());
    }

    private static final class Entry {
        final String name;
        final Class<?> type;
        final ByteHandle<?> handle;

        Entry(String name, Class<?> type, ByteHandle<?> handle) {
            this.name = name;
            this.type = type;
            this.handle = handle;
        }
    }
}

