/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config.mutable;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.byteunion.Json;
import net.byteunion.JsonArray;
import net.byteunion.JsonBoolean;
import net.byteunion.JsonNull;
import net.byteunion.JsonNumber;
import net.byteunion.JsonObject;
import net.byteunion.JsonString;
import net.byteunion.JsonValue;
import net.byteunion.config.EnvOverrides;
import net.byteunion.config.JsonBind;
import net.byteunion.config.JsonMerge;
import net.byteunion.io.JsonWriter;

public final class ByteHandle<T> {
    private final Path path;
    private final Class<T> type;
    private final JsonObject root;

    private ByteHandle(Path path, Class<T> type, JsonObject root) {
        this.path = path;
        this.type = type;
        this.root = root;
    }

    public static <T> ByteHandle<T> loadOrCreate(Path path, Class<T> modelType, Supplier<T> defaults, String envPrefix) throws IOException {
        JsonObject out;
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(modelType, "modelType");
        Objects.requireNonNull(defaults, "defaults");
        JsonObject defObj = ByteHandle.ensureObject(JsonBind.toJson(defaults.get()));
        if (Files.notExists(path, new LinkOption[0])) {
            out = defObj;
            ByteHandle.save(path, out);
        } else {
            String txt = Files.readString(path);
            JsonValue parsed = Json.parse(txt);
            JsonObject got = ByteHandle.ensureObject(parsed);
            JsonObject merged = (JsonObject)JsonMerge.deepMerge(defObj, got);
            String sysPrefix = envPrefix != null && !envPrefix.isBlank() ? envPrefix.toLowerCase() + "." : null;
            EnvOverrides.apply(merged, envPrefix, sysPrefix);
            out = merged;
        }
        return new ByteHandle<T>(path, modelType, out);
    }

    public T model() {
        return JsonBind.fromJson(this.root, this.type);
    }

    public ByteHandle<T> replaceWith(T model) {
        JsonObject obj = ByteHandle.ensureObject(JsonBind.toJson(model));
        this.root.clear();
        for (Map.Entry<String, JsonValue> e : obj) {
            this.root.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public void save() throws IOException {
        ByteHandle.save(this.path, this.root);
    }

    public JsonObject json() {
        return this.root;
    }

    public Node rootNode() {
        return new Node(this, null, null);
    }

    public Node section(String name) {
        return this.rootNode().child(name);
    }

    public Node at(String dottedPath) {
        Node n = this.rootNode();
        if (dottedPath == null || dottedPath.isBlank()) {
            return n;
        }
        for (String part : dottedPath.split("\\.")) {
            if (part.isEmpty()) continue;
            n = n.child(part);
        }
        return n;
    }

    private static void save(Path path, JsonObject obj) throws IOException {
        String pretty = JsonWriter.pretty(obj);
        if (path.getParent() != null) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.writeString(path, (CharSequence)pretty, new OpenOption[0]);
    }

    private static JsonObject ensureObject(JsonValue v) {
        if (v instanceof JsonObject) {
            JsonObject o = (JsonObject)v;
            return o;
        }
        throw new IllegalArgumentException("Top-level object required");
    }

    private static JsonValue wrap(Object v) {
        if (v == null) {
            return JsonNull.NULL;
        }
        if (v instanceof JsonValue) {
            JsonValue jv = (JsonValue)v;
            return jv;
        }
        return JsonBind.toJson(v);
    }

    public static final class Node {
        private final ByteHandle<?> owner;
        private final Node parent;
        private final String key;

        private Node(ByteHandle<?> owner, Node parent, String key) {
            this.owner = owner;
            this.parent = parent;
            this.key = key;
        }

        public Node child(String name) {
            return new Node(this.owner, this, name);
        }

        public Node at(String dotted) {
            Node n = this;
            if (dotted == null || dotted.isBlank()) {
                return n;
            }
            for (String part : dotted.split("\\.")) {
                if (part.isEmpty()) continue;
                n = n.child(part);
            }
            return n;
        }

        public List<String> keys() {
            JsonObject o = this.asObject();
            ArrayList<String> out = new ArrayList<String>();
            if (o != null) {
                for (Map.Entry<String, JsonValue> e : o) {
                    out.add(e.getKey());
                }
            }
            return out;
        }

        public boolean exists() {
            if (this.parent == null) {
                return true;
            }
            JsonObject po = this.parent.asObject();
            return po != null && po.get(this.key) != null;
        }

        public Node set(Object value) {
            if (this.parent == null) {
                JsonObject ro = ByteHandle.ensureObject(ByteHandle.wrap(value));
                this.owner.root.clear();
                for (Map.Entry<String, JsonValue> e : ro) {
                    this.owner.root.put(e.getKey(), e.getValue());
                }
                return this;
            }
            JsonObject p = this.parent.ensureObjectHere();
            p.put(this.key, ByteHandle.wrap(value));
            return this;
        }

        public Node set(String field, Object value) {
            JsonObject o = this.ensureObjectHere();
            o.put(field, ByteHandle.wrap(value));
            return this;
        }

        public boolean remove() {
            if (this.parent == null) {
                return false;
            }
            JsonObject p = this.parent.asObject();
            if (p == null) {
                return false;
            }
            return p.remove(this.key);
        }

        public Node push(Object value) {
            JsonArray arr = this.ensureArrayHere();
            arr.add(ByteHandle.wrap(value));
            return this;
        }

        public JsonValue get(String field) {
            JsonObject o = this.asObject();
            return o != null ? o.get(field) : null;
        }

        public String getString(String field) {
            String string;
            JsonValue v = this.get(field);
            if (v instanceof JsonString) {
                JsonString s = (JsonString)v;
                string = s.value();
            } else {
                string = v != null ? v.toString() : null;
            }
            return string;
        }

        public int getInt(String field, int def) {
            JsonValue v = this.get(field);
            if (v instanceof JsonNumber) {
                JsonNumber n = (JsonNumber)v;
                return n.value().intValue();
            }
            try {
                return v != null ? Integer.parseInt(v.toString()) : def;
            }
            catch (Exception e) {
                return def;
            }
        }

        public long getLong(String field, long def) {
            JsonValue v = this.get(field);
            if (v instanceof JsonNumber) {
                JsonNumber n = (JsonNumber)v;
                return n.value().longValue();
            }
            try {
                return v != null ? Long.parseLong(v.toString()) : def;
            }
            catch (Exception e) {
                return def;
            }
        }

        public boolean getBool(String field, boolean def) {
            JsonValue v = this.get(field);
            if (v instanceof JsonBoolean) {
                JsonBoolean b = (JsonBoolean)v;
                return b.value();
            }
            return v != null ? Boolean.parseBoolean(v.toString()) : def;
        }

        public JsonArray getArray(String field) {
            JsonArray a;
            JsonValue v = this.get(field);
            return v instanceof JsonArray ? (a = (JsonArray)v) : null;
        }

        public JsonObject getObject(String field) {
            JsonObject o;
            JsonValue v = this.get(field);
            return v instanceof JsonObject ? (o = (JsonObject)v) : null;
        }

        public JsonObject ensureObjectHere() {
            JsonObject obj;
            if (this.parent == null) {
                return this.owner.root;
            }
            JsonObject po = this.parent.ensureObjectHere();
            JsonValue cur = po.get(this.key);
            if (cur instanceof JsonObject) {
                JsonObject jo;
                obj = jo = (JsonObject)cur;
            } else {
                obj = new JsonObject();
                po.put(this.key, obj);
            }
            return obj;
        }

        public JsonArray ensureArrayHere() {
            JsonArray arr;
            if (this.parent == null) {
                throw new IllegalStateException("Root cannot become array");
            }
            JsonObject po = this.parent.ensureObjectHere();
            JsonValue cur = po.get(this.key);
            if (cur instanceof JsonArray) {
                JsonArray ja;
                arr = ja = (JsonArray)cur;
            } else {
                arr = new JsonArray();
                po.put(this.key, arr);
            }
            return arr;
        }

        public JsonObject asObject() {
            JsonObject o;
            if (this.parent == null) {
                return this.owner.root;
            }
            JsonObject po = this.parent.asObject();
            if (po == null) {
                return null;
            }
            JsonValue v = po.get(this.key);
            return v instanceof JsonObject ? (o = (JsonObject)v) : null;
        }

        public JsonArray asArray() {
            JsonArray a;
            if (this.parent == null) {
                return null;
            }
            JsonObject po = this.parent.asObject();
            if (po == null) {
                return null;
            }
            JsonValue v = po.get(this.key);
            return v instanceof JsonArray ? (a = (JsonArray)v) : null;
        }
    }
}

