/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public final class ConfigWatcher
implements AutoCloseable {
    private final WatchService ws;
    private final Path dir;
    private final Path file;
    private final ExecutorService exec = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "draconic-config-watcher");
        t.setDaemon(true);
        return t;
    });
    private volatile boolean running = true;

    public ConfigWatcher(Path file, Consumer<Path> onChange) throws IOException {
        this.file = file.toAbsolutePath().normalize();
        this.dir = this.file.getParent();
        this.ws = FileSystems.getDefault().newWatchService();
        this.dir.register(this.ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
        this.exec.submit(() -> this.loop(onChange));
    }

    private void loop(Consumer<Path> onChange) {
        while (this.running) {
            try {
                WatchKey key = this.ws.take();
                for (WatchEvent<?> ev : key.pollEvents()) {
                    Path changed = this.dir.resolve((Path)ev.context()).toAbsolutePath().normalize();
                    if (!changed.equals(this.file)) continue;
                    onChange.accept(this.file);
                }
                key.reset();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        this.ws.close();
        this.exec.shutdownNow();
    }
}

