/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import net.byteunion.Json;
import net.byteunion.JsonObject;
import net.byteunion.JsonValue;
import net.byteunion.config.EnvOverrides;
import net.byteunion.config.JsonBind;
import net.byteunion.config.JsonMerge;
import net.byteunion.io.JsonWriter;

public final class ByteConfig {
    private ByteConfig() {
    }

    public static <T> T loadOrCreate(Path path, Class<T> type, Supplier<T> defaults, String envPrefix) throws IOException {
        JsonObject out;
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(defaults, "defaults");
        JsonObject defObj = ByteConfig.ensureObject(JsonBind.toJson(defaults.get()));
        if (Files.notExists(path, new LinkOption[0])) {
            out = defObj;
            ByteConfig.save(path, out);
        } else {
            String txt = Files.readString(path);
            JsonValue v = Json.parse(txt);
            JsonObject got = ByteConfig.ensureObject(v);
            JsonObject merged = (JsonObject)JsonMerge.deepMerge(defObj, got);
            String sysPrefix = envPrefix != null && !envPrefix.isBlank() ? envPrefix.toLowerCase() + "." : null;
            EnvOverrides.apply(merged, envPrefix, sysPrefix);
            out = merged;
        }
        return JsonBind.fromJson(out, type);
    }

    public static void save(Path path, Object cfg) throws IOException {
        JsonValue jv;
        JsonValue v = cfg instanceof JsonValue ? (jv = (JsonValue)cfg) : JsonBind.toJson(cfg);
        String pretty = JsonWriter.pretty(v);
        if (path.getParent() != null) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.writeString(path, (CharSequence)pretty, new OpenOption[0]);
    }

    public static JsonObject ensureObject(JsonValue v) {
        if (v instanceof JsonObject) {
            JsonObject o = (JsonObject)v;
            return o;
        }
        throw new IllegalArgumentException("Top-level object required");
    }
}

