/*
 * Decompiled with CFR 0.152.
 */
package net.byteunion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Map;
import net.byteunion.JsonArray;
import net.byteunion.JsonBoolean;
import net.byteunion.JsonNull;
import net.byteunion.JsonNumber;
import net.byteunion.JsonObject;
import net.byteunion.JsonString;
import net.byteunion.JsonValue;
import net.byteunion.io.JsonTree;
import net.byteunion.io.JsonWriter;

public final class Json {
    private Json() {
    }

    public static JsonValue parse(String json) {
        return JsonTree.parse(json);
    }

    public static JsonValue parse(InputStream is) {
        return JsonTree.parse(is);
    }

    public static JsonValue parse(File file) {
        try {
            return JsonTree.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject object(Object ... items) {
        JsonObject object = new JsonObject();
        for (int i = 0; i < items.length; i += 2) {
            object.put(String.valueOf(items[i]), Json.wrap(items[i + 1]));
        }
        return object;
    }

    public static JsonArray array(Object ... items) {
        JsonArray array = new JsonArray();
        for (Object it : items) {
            array.add(Json.wrap(it));
        }
        return array;
    }

    public static JsonValue wrap(Object v) {
        if (v == null) {
            return JsonNull.NULL;
        }
        if (v instanceof JsonValue) {
            JsonValue jv = (JsonValue)v;
            return jv;
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return b != false ? JsonBoolean.TRUE : JsonBoolean.FALSE;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return new JsonNumber(new BigDecimal(n.toString()));
        }
        if (v instanceof CharSequence) {
            CharSequence cs = (CharSequence)v;
            return new JsonString(cs.toString());
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            JsonObject o = new JsonObject();
            for (Map.Entry e : m.entrySet()) {
                o.put(String.valueOf(e.getKey()), Json.wrap(e.getValue()));
            }
            return o;
        }
        if (v instanceof Iterable) {
            Iterable it = (Iterable)v;
            JsonArray a = new JsonArray();
            for (Object x : it) {
                a.add(Json.wrap(x));
            }
            return a;
        }
        return new JsonString(String.valueOf(v));
    }

    public static String stringify(JsonValue value) {
        return JsonWriter.stringify(value);
    }

    public static String pretty(JsonValue value) {
        return JsonWriter.pretty(value);
    }

    public static byte[] bytes(JsonValue value) {
        return JsonWriter.bytes(value);
    }

    public static String str(JsonObject object, String key) {
        String string;
        JsonValue value = object.get(key);
        if (value instanceof JsonString) {
            JsonString string2 = (JsonString)value;
            string = string2.value();
        } else {
            string = null;
        }
        return string;
    }

    public static Long lng(JsonObject object, String key) {
        Long l;
        JsonValue value = object.get(key);
        if (value instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)value;
            l = number.asLong();
        } else {
            l = null;
        }
        return l;
    }

    public static Double dbl(JsonObject object, String key) {
        Double d;
        JsonValue value = object.get(key);
        if (value instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)value;
            d = number.asDouble();
        } else {
            d = null;
        }
        return d;
    }

    public static Boolean bool(JsonObject object, String key) {
        Boolean bl;
        JsonValue value = object.get(key);
        if (value instanceof JsonBoolean) {
            JsonBoolean bool = (JsonBoolean)value;
            bl = bool.value();
        } else {
            bl = null;
        }
        return bl;
    }

    public static JsonObject obj(JsonObject object, String key) {
        JsonObject jsonObject;
        JsonValue value = object.get(key);
        if (value instanceof JsonObject) {
            JsonObject obj = (JsonObject)value;
            jsonObject = (JsonObject)value;
        } else {
            jsonObject = null;
        }
        return jsonObject;
    }

    public static JsonArray arr(JsonObject object, String key) {
        JsonArray jsonArray;
        JsonValue value = object.get(key);
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            jsonArray = (JsonArray)value;
        } else {
            jsonArray = null;
        }
        return jsonArray;
    }
}

