/*
 * Decompiled with CFR 0.152.
 */
package community.theprojects.shaded.fastutil.shorts;

import community.theprojects.shaded.fastutil.Size64;
import community.theprojects.shaded.fastutil.chars.AbstractCharCollection;
import community.theprojects.shaded.fastutil.chars.CharCollection;
import community.theprojects.shaded.fastutil.chars.CharConsumer;
import community.theprojects.shaded.fastutil.chars.CharIterator;
import community.theprojects.shaded.fastutil.chars.CharSpliterator;
import community.theprojects.shaded.fastutil.chars.CharSpliterators;
import community.theprojects.shaded.fastutil.objects.AbstractObjectSet;
import community.theprojects.shaded.fastutil.objects.ObjectIterator;
import community.theprojects.shaded.fastutil.objects.ObjectSpliterator;
import community.theprojects.shaded.fastutil.objects.ObjectSpliterators;
import community.theprojects.shaded.fastutil.shorts.AbstractShort2CharFunction;
import community.theprojects.shaded.fastutil.shorts.AbstractShortSet;
import community.theprojects.shaded.fastutil.shorts.Short2CharMap;
import community.theprojects.shaded.fastutil.shorts.Short2CharMaps;
import community.theprojects.shaded.fastutil.shorts.ShortConsumer;
import community.theprojects.shaded.fastutil.shorts.ShortIterator;
import community.theprojects.shaded.fastutil.shorts.ShortSet;
import community.theprojects.shaded.fastutil.shorts.ShortSpliterator;
import community.theprojects.shaded.fastutil.shorts.ShortSpliterators;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractShort2CharMap
extends AbstractShort2CharFunction
implements Short2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractShort2CharMap() {
    }

    @Override
    public boolean containsKey(short k) {
        Iterator i = this.short2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Short2CharMap.Entry)i.next()).getShortKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(char v) {
        Iterator i = this.short2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Short2CharMap.Entry)i.next()).getCharValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            @Override
            public boolean contains(short k) {
                return AbstractShort2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractShort2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2CharMap.this.clear();
            }

            @Override
            public ShortIterator iterator() {
                return new ShortIterator(){
                    private final ObjectIterator<Short2CharMap.Entry> i;
                    {
                        this.i = Short2CharMaps.fastIterator(AbstractShort2CharMap.this);
                    }

                    @Override
                    public short nextShort() {
                        return ((Short2CharMap.Entry)this.i.next()).getShortKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(ShortConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getShortKey()));
                    }
                };
            }

            @Override
            public ShortSpliterator spliterator() {
                return ShortSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractShort2CharMap.this), 321);
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k) {
                return AbstractShort2CharMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractShort2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractShort2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Short2CharMap.Entry> i;
                    {
                        this.i = Short2CharMaps.fastIterator(AbstractShort2CharMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Short2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(CharConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getCharValue()));
                    }
                };
            }

            @Override
            public CharSpliterator spliterator() {
                return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractShort2CharMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Character> m) {
        if (m instanceof Short2CharMap) {
            ObjectIterator<Short2CharMap.Entry> i = Short2CharMaps.fastIterator((Short2CharMap)m);
            while (i.hasNext()) {
                Short2CharMap.Entry e = (Short2CharMap.Entry)i.next();
                this.put(e.getShortKey(), e.getCharValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Short, ? extends Character>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Short, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Short2CharMap.Entry> i = Short2CharMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Short2CharMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.short2CharEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Short2CharMap.Entry> i = Short2CharMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2CharMap.Entry e = (Short2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Short2CharMap.Entry> {
        protected final Short2CharMap map;

        public BasicEntrySet(Short2CharMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Short2CharMap.Entry) {
                Short2CharMap.Entry e = (Short2CharMap.Entry)o;
                short k = e.getShortKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getCharValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k = (Short)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Character)value).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Short2CharMap.Entry) {
                Short2CharMap.Entry e = (Short2CharMap.Entry)o;
                return this.map.remove(e.getShortKey(), e.getCharValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            short k = (Short)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            char v = ((Character)value).charValue();
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Short2CharMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry
    implements Short2CharMap.Entry {
        protected short key;
        protected char value;

        public BasicEntry() {
        }

        public BasicEntry(Short key, Character value) {
            this.key = key;
            this.value = value.charValue();
        }

        public BasicEntry(short key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short getShortKey() {
            return this.key;
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Short2CharMap.Entry) {
                Short2CharMap.Entry e = (Short2CharMap.Entry)o;
                return this.key == e.getShortKey() && this.value == e.getCharValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Short)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Character)) {
                return false;
            }
            return this.key == (Short)key && this.value == ((Character)value).charValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

