/*
 * Decompiled with CFR 0.152.
 */
package community.theprojects.shaded.fastutil.floats;

import community.theprojects.shaded.fastutil.HashCommon;
import community.theprojects.shaded.fastutil.Size64;
import community.theprojects.shaded.fastutil.doubles.AbstractDoubleCollection;
import community.theprojects.shaded.fastutil.doubles.DoubleBinaryOperator;
import community.theprojects.shaded.fastutil.doubles.DoubleCollection;
import community.theprojects.shaded.fastutil.doubles.DoubleIterator;
import community.theprojects.shaded.fastutil.doubles.DoubleSpliterator;
import community.theprojects.shaded.fastutil.doubles.DoubleSpliterators;
import community.theprojects.shaded.fastutil.floats.AbstractFloat2DoubleFunction;
import community.theprojects.shaded.fastutil.floats.AbstractFloatSet;
import community.theprojects.shaded.fastutil.floats.Float2DoubleMap;
import community.theprojects.shaded.fastutil.floats.Float2DoubleMaps;
import community.theprojects.shaded.fastutil.floats.FloatConsumer;
import community.theprojects.shaded.fastutil.floats.FloatIterator;
import community.theprojects.shaded.fastutil.floats.FloatSet;
import community.theprojects.shaded.fastutil.floats.FloatSpliterator;
import community.theprojects.shaded.fastutil.floats.FloatSpliterators;
import community.theprojects.shaded.fastutil.objects.AbstractObjectSet;
import community.theprojects.shaded.fastutil.objects.ObjectIterator;
import community.theprojects.shaded.fastutil.objects.ObjectSpliterator;
import community.theprojects.shaded.fastutil.objects.ObjectSpliterators;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.DoubleConsumer;

public abstract class AbstractFloat2DoubleMap
extends AbstractFloat2DoubleFunction
implements Float2DoubleMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractFloat2DoubleMap() {
    }

    @Override
    public boolean containsKey(float k) {
        Iterator i = this.float2DoubleEntrySet().iterator();
        while (i.hasNext()) {
            if (((Float2DoubleMap.Entry)i.next()).getFloatKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(double v) {
        Iterator i = this.float2DoubleEntrySet().iterator();
        while (i.hasNext()) {
            if (((Float2DoubleMap.Entry)i.next()).getDoubleValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final double mergeDouble(float key, double value, DoubleBinaryOperator remappingFunction) {
        return this.mergeDouble(key, value, (java.util.function.DoubleBinaryOperator)remappingFunction);
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            @Override
            public boolean contains(float k) {
                return AbstractFloat2DoubleMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractFloat2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2DoubleMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Float2DoubleMap.Entry> i;
                    {
                        this.i = Float2DoubleMaps.fastIterator(AbstractFloat2DoubleMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Float2DoubleMap.Entry)this.i.next()).getFloatKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(FloatConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getFloatKey()));
                    }
                };
            }

            @Override
            public FloatSpliterator spliterator() {
                return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractFloat2DoubleMap.this), 321);
            }
        };
    }

    @Override
    public DoubleCollection values() {
        return new AbstractDoubleCollection(){

            @Override
            public boolean contains(double k) {
                return AbstractFloat2DoubleMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractFloat2DoubleMap.this.size();
            }

            @Override
            public void clear() {
                AbstractFloat2DoubleMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Float2DoubleMap.Entry> i;
                    {
                        this.i = Float2DoubleMaps.fastIterator(AbstractFloat2DoubleMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Float2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(DoubleConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getDoubleValue()));
                    }
                };
            }

            @Override
            public DoubleSpliterator spliterator() {
                return DoubleSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractFloat2DoubleMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Double> m) {
        if (m instanceof Float2DoubleMap) {
            ObjectIterator<Float2DoubleMap.Entry> i = Float2DoubleMaps.fastIterator((Float2DoubleMap)m);
            while (i.hasNext()) {
                Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getDoubleValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Float, ? extends Double>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Float, ? extends Double> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Float2DoubleMap.Entry> i = Float2DoubleMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Float2DoubleMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.float2DoubleEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Float2DoubleMap.Entry> i = Float2DoubleMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Float2DoubleMap.Entry> {
        protected final Float2DoubleMap map;

        public BasicEntrySet(Float2DoubleMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2DoubleMap.Entry) {
                Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)o;
                float k = e.getFloatKey();
                return this.map.containsKey(k) && Double.doubleToRawLongBits(this.map.get(k)) == Double.doubleToRawLongBits(e.getDoubleValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k = ((Float)key).floatValue();
            Object value = e.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return this.map.containsKey(k) && Double.doubleToRawLongBits(this.map.get(k)) == Double.doubleToRawLongBits((Double)value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2DoubleMap.Entry) {
                Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)o;
                return this.map.remove(e.getFloatKey(), e.getDoubleValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            float k = ((Float)key).floatValue();
            Object value = e.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            double v = (Double)value;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Float2DoubleMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry
    implements Float2DoubleMap.Entry {
        protected float key;
        protected double value;

        public BasicEntry() {
        }

        public BasicEntry(Float key, Double value) {
            this.key = key.floatValue();
            this.value = value;
        }

        public BasicEntry(float key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public float getFloatKey() {
            return this.key;
        }

        @Override
        public double getDoubleValue() {
            return this.value;
        }

        @Override
        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Float2DoubleMap.Entry) {
                Float2DoubleMap.Entry e = (Float2DoubleMap.Entry)o;
                return Float.floatToRawIntBits(this.key) == Float.floatToRawIntBits(e.getFloatKey()) && Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(e.getDoubleValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Float)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Double)) {
                return false;
            }
            return Float.floatToRawIntBits(this.key) == Float.floatToRawIntBits(((Float)key).floatValue()) && Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits((Double)value);
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(this.key) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

