/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.util.vtype;

import java.nio.ByteBuffer;

public class VLong {
    public static void writeVLong(ByteBuffer buffer, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.put((byte)(value & 0x7FL));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            buffer.put((byte)(0x80L | value >>> 8 & 0x3FL));
            buffer.put((byte)(value & 0xFFL));
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            buffer.put((byte)(0xC0L | value >>> 16 & 0x1FL));
            buffer.put((byte)(value >>> 8 & 0xFFL));
            buffer.put((byte)(value & 0xFFL));
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            buffer.put((byte)(0xE0L | value >>> 24 & 0xFL));
            buffer.put((byte)(value >>> 16 & 0xFFL));
            buffer.put((byte)(value >>> 8 & 0xFFL));
            buffer.put((byte)(value & 0xFFL));
        } else {
            buffer.put((byte)(0xF0L | value >>> 32 & 7L));
            buffer.put((byte)(value >>> 24 & 0xFFL));
            buffer.put((byte)(value >>> 16 & 0xFFL));
            buffer.put((byte)(value >>> 8 & 0xFFL));
            buffer.put((byte)(value & 0xFFL));
        }
    }

    public static long readVLong(ByteBuffer buffer) {
        long value;
        byte firstByte = buffer.get();
        if ((firstByte & 0x80) == 0) {
            value = firstByte & 0x7F;
        } else if ((firstByte & 0xC0) == 128) {
            value = (firstByte & 0x3F) << 8;
            value |= (long)(buffer.get() & 0xFF);
        } else if ((firstByte & 0xE0) == 192) {
            value = (firstByte & 0x1F) << 16;
            value |= (long)((buffer.get() & 0xFF) << 8);
            value |= (long)(buffer.get() & 0xFF);
        } else {
            value = (firstByte & 0xF) << 24;
            value |= (long)((buffer.get() & 0xFF) << 16);
            value |= (long)((buffer.get() & 0xFF) << 8);
            value |= (long)(buffer.get() & 0xFF);
        }
        return value;
    }
}

