/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.util;

import java.util.concurrent.ForkJoinPool;

public class TaskExecutor {
    private final ForkJoinPool ioThreadPool;
    private final ForkJoinPool workerThreadPool;

    public TaskExecutor(int parallelism) {
        this.ioThreadPool = new ForkJoinPool(parallelism);
        this.workerThreadPool = new ForkJoinPool(parallelism);
    }

    public void submitIoTask(Runnable task) {
        this.ioThreadPool.execute(task);
    }

    public void submitWorkerTask(Runnable task) {
        this.workerThreadPool.execute(task);
    }

    public void shutdown() {
        this.ioThreadPool.shutdown();
        this.workerThreadPool.shutdown();
    }
}

