/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import me.syntaxjason.syntaxjasonapi.networking.UltraServer;

public class DebugLogger {
    private static DebugLogger instance;
    private LogLevel currentLevel = LogLevel.INFO;
    private PrintWriter consoleWriter = new PrintWriter(System.out, true);
    private PrintWriter fileWriter;
    private boolean logToFile = false;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private DebugLogger() {
    }

    public static synchronized DebugLogger getInstance() {
        if (instance == null) {
            instance = new DebugLogger();
        }
        return instance;
    }

    public void setLogLevel(LogLevel level) {
        this.currentLevel = level;
    }

    public void enableFileLogging(String filePath) {
        try {
            this.fileWriter = new PrintWriter(new FileWriter(filePath, true));
            this.logToFile = true;
            this.log(LogLevel.INFO, "File logging enabled: " + filePath);
        }
        catch (IOException e) {
            this.log(LogLevel.ERROR, "Failed to enable file logging: " + e.getMessage());
        }
    }

    public void disableFileLogging() {
        if (this.logToFile) {
            this.log(LogLevel.INFO, "File logging disabled.");
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
            this.logToFile = false;
        }
    }

    public void log(LogLevel level, String message) {
        if (UltraServer.isDebug() && level.ordinal() >= this.currentLevel.ordinal()) {
            String timestampedMessage = this.formatMessage(level, message);
            this.logToConsole(timestampedMessage);
            if (this.logToFile) {
                this.logToFile(timestampedMessage);
            }
        }
    }

    private void logToConsole(String message) {
        this.consoleWriter.println(message);
    }

    private void logToFile(String message) {
        if (this.logToFile && this.fileWriter != null) {
            this.fileWriter.println(message);
            this.fileWriter.flush();
        }
    }

    private String formatMessage(LogLevel level, String message) {
        String timestamp = LocalDateTime.now().format(this.formatter);
        return "[" + timestamp + "][" + String.valueOf((Object)level) + "] " + message;
    }

    public void debug(String message) {
        if (UltraServer.isDebug()) {
            this.log(LogLevel.DEBUG, message);
        }
    }

    public void info(String message) {
        this.log(LogLevel.INFO, message);
    }

    public void warn(String message) {
        this.log(LogLevel.WARN, message);
    }

    public void error(String message) {
        this.log(LogLevel.ERROR, message);
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

