/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.pipe.managing;

import java.nio.channels.AsynchronousSocketChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.syntaxjason.syntaxjasonapi.networking.pipe.managing.ConnectionManager;
import me.syntaxjason.syntaxjasonapi.networking.util.TaskExecutor;

public class TimeoutManager {
    private final Map<AsynchronousSocketChannel, Instant> lastActivity = new ConcurrentHashMap<AsynchronousSocketChannel, Instant>();
    private final ConnectionManager connectionManager;
    private final TaskExecutor taskExecutor;
    private final long timeoutMillis;

    public TimeoutManager(ConnectionManager connectionManager, TaskExecutor taskExecutor, long timeoutMillis) {
        this.connectionManager = connectionManager;
        this.taskExecutor = taskExecutor;
        this.timeoutMillis = timeoutMillis;
        this.scheduleTimeoutCheck();
    }

    public void recordActivity(AsynchronousSocketChannel channel) {
        this.lastActivity.put(channel, Instant.now());
    }

    private void scheduleTimeoutCheck() {
        this.taskExecutor.submitWorkerTask(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(60000L);
                    this.checkForTimeouts();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    private void checkForTimeouts() {
        Instant now = Instant.now();
        for (AsynchronousSocketChannel channel : this.lastActivity.keySet()) {
            Instant lastActive = this.lastActivity.get(channel);
            if (Duration.between(lastActive, now).toMillis() <= this.timeoutMillis) continue;
            this.taskExecutor.submitIoTask(() -> {
                System.out.println("Connection timeout: " + String.valueOf(channel));
                this.connectionManager.disconnect(channel);
            });
        }
    }
}

