/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.pipe.managing;

import java.time.Duration;
import java.time.Instant;
import me.syntaxjason.syntaxjasonapi.networking.channel.AsyncClientChannel;
import me.syntaxjason.syntaxjasonapi.networking.pipe.NioPipeline;

public class ConnectionMetadata {
    private final AsyncClientChannel clientChannel;
    private final Instant connectionStart;
    private long bytesReceived;
    private long bytesSent;
    private NioPipeline pipeline;

    public ConnectionMetadata(AsyncClientChannel clientChannel) {
        this.clientChannel = clientChannel;
        this.connectionStart = Instant.now();
        this.bytesReceived = 0L;
        this.bytesSent = 0L;
    }

    public Instant getConnectionStart() {
        return this.connectionStart;
    }

    public Duration getConnectionDuration() {
        return Duration.between(this.connectionStart, Instant.now());
    }

    public void incrementBytesReceived(long bytes) {
        this.bytesReceived += bytes;
    }

    public void incrementBytesSent(long bytes) {
        this.bytesSent += bytes;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public AsyncClientChannel getClientChannel() {
        return this.clientChannel;
    }

    public NioPipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(NioPipeline pipeline) {
        this.pipeline = pipeline;
    }
}

