/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.pipe.managing;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.syntaxjason.syntaxjasonapi.networking.channel.AsyncClientChannel;
import me.syntaxjason.syntaxjasonapi.networking.pipe.NioPipeline;
import me.syntaxjason.syntaxjasonapi.networking.pipe.managing.ConnectionMetadata;
import me.syntaxjason.syntaxjasonapi.networking.util.DebugLogger;

public class ConnectionManager {
    private final DebugLogger logger = DebugLogger.getInstance();
    private final Map<AsynchronousSocketChannel, ConnectionMetadata> connections = new ConcurrentHashMap<AsynchronousSocketChannel, ConnectionMetadata>();

    public void registerConnection(NioPipeline pipeline) {
        AsyncClientChannel clientChannel = pipeline.getClientChannel();
        ConnectionMetadata metadata = new ConnectionMetadata(clientChannel);
        this.connections.put(clientChannel.getChannel(), metadata);
        System.out.println("Connection registered: " + String.valueOf(clientChannel.getChannel()));
    }

    public void unregisterConnection(AsynchronousSocketChannel channel) {
        this.connections.remove(channel);
        System.out.println("Connection unregistered: " + String.valueOf(channel));
    }

    public ConnectionMetadata getConnectionMetadata(AsynchronousSocketChannel channel) {
        return this.connections.get(channel);
    }

    public Map<AsynchronousSocketChannel, ConnectionMetadata> getActiveConnections() {
        return this.connections;
    }

    public void disconnect(AsynchronousSocketChannel channel) {
        ConnectionMetadata metadata = this.connections.get(channel);
        if (metadata != null) {
            metadata.getPipeline().close();
            this.unregisterConnection(channel);
            this.logger.info("Connection forcibly disconnected: " + String.valueOf(channel));
        }
    }

    public void pauseConnection(AsynchronousSocketChannel channel) {
        this.logger.info("Pausing connection: " + String.valueOf(channel));
    }

    public void resumeConnection(AsynchronousSocketChannel channel) {
        this.logger.info("Resuming connection: " + String.valueOf(channel));
    }
}

