/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.pipe;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ConcurrentHashMap;
import me.syntaxjason.syntaxjasonapi.networking.buffer.BufferPool;
import me.syntaxjason.syntaxjasonapi.networking.channel.AsyncClientChannel;
import me.syntaxjason.syntaxjasonapi.networking.channel.ServerChannel;
import me.syntaxjason.syntaxjasonapi.networking.pipe.NioPipeline;
import me.syntaxjason.syntaxjasonapi.networking.pipe.handler.PipelineEventHandler;
import me.syntaxjason.syntaxjasonapi.networking.pipe.handler.PipelineHandler;
import me.syntaxjason.syntaxjasonapi.networking.pipe.managing.ConnectionManager;
import me.syntaxjason.syntaxjasonapi.networking.util.DebugLogger;
import me.syntaxjason.syntaxjasonapi.networking.util.NetworkProperties;

public class PipelineOrchestrator {
    private final NetworkProperties properties;
    private final DebugLogger logger;
    private final ConnectionManager connectionManager;
    private final ServerChannel serverChannel;
    private final ConcurrentHashMap<AsynchronousSocketChannel, NioPipeline> activePipelines;
    private PipelineEventHandler eventHandler;

    public PipelineOrchestrator(NetworkProperties properties) throws IOException {
        this.properties = properties;
        this.logger = DebugLogger.getInstance();
        this.connectionManager = new ConnectionManager();
        this.serverChannel = new ServerChannel(properties.getHost(), properties.getPort());
        this.activePipelines = new ConcurrentHashMap();
    }

    public void start() throws IOException {
        this.serverChannel.open();
        this.logger.info("PipelineOrchestrator started on " + this.properties.getHost() + ":" + this.properties.getPort());
        this.acceptConnections();
    }

    private void acceptConnections() {
        this.serverChannel.getChannel().accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

            @Override
            public void completed(AsynchronousSocketChannel clientChannel, Void attachment) {
                PipelineOrchestrator.this.logger.info("New connection accepted: " + String.valueOf(clientChannel));
                AsyncClientChannel asyncClientChannel = new AsyncClientChannel(clientChannel, new BufferPool(PipelineOrchestrator.this.properties.getDefaultBufferSize(), PipelineOrchestrator.this.properties.getMaxBufferSize(), PipelineOrchestrator.this.properties.getPoolSize()));
                NioPipeline pipeline = new NioPipeline(asyncClientChannel);
                if (PipelineOrchestrator.this.eventHandler != null) {
                    pipeline.addEventHandler(PipelineOrchestrator.this.eventHandler);
                }
                PipelineOrchestrator.this.activePipelines.put(clientChannel, pipeline);
                pipeline.startRead();
                PipelineOrchestrator.this.serverChannel.getChannel().accept(null, this);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                PipelineOrchestrator.this.logger.error("Failed to accept connection: " + exc.getMessage());
            }
        });
    }

    public void addEventHandler(PipelineEventHandler handler) {
        this.eventHandler = handler;
    }

    public void addPipelineHandler(NioPipeline pipeline, PipelineHandler handler) {
        pipeline.addHandler(handler);
    }

    public void disconnectClient(AsynchronousSocketChannel channel) {
        NioPipeline pipeline = this.activePipelines.remove(channel);
        if (pipeline != null) {
            this.connectionManager.disconnect(channel);
            this.closeChannelSilently(channel);
            this.logger.info("Disconnected client: " + String.valueOf(channel));
        } else {
            this.logger.warn("Attempted to disconnect non-existent client: " + String.valueOf(channel));
        }
    }

    private void closeChannelSilently(AsynchronousSocketChannel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            this.logger.error("Failed to close channel: " + e.getMessage());
        }
    }

    public void shutdown() throws IOException {
        this.activePipelines.forEach((channel, pipeline) -> this.disconnectClient((AsynchronousSocketChannel)channel));
        this.serverChannel.close();
        this.logger.info("PipelineOrchestrator shutdown complete.");
    }
}

