/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.pipe;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import me.syntaxjason.syntaxjasonapi.networking.channel.AsyncClientChannel;
import me.syntaxjason.syntaxjasonapi.networking.pipe.handler.PipelineEventHandler;
import me.syntaxjason.syntaxjasonapi.networking.pipe.handler.PipelineHandler;

public class NioPipeline {
    private final AsyncClientChannel clientChannel;
    private final List<PipelineHandler> handlers;
    private final List<PipelineEventHandler> eventHandlers;

    public NioPipeline(AsyncClientChannel clientChannel) {
        this.clientChannel = clientChannel;
        this.handlers = new ArrayList<PipelineHandler>();
        this.eventHandlers = new ArrayList<PipelineEventHandler>();
    }

    public void addHandler(PipelineHandler handler) {
        this.handlers.add(handler);
    }

    public void addEventHandler(PipelineEventHandler eventHandler) {
        this.eventHandlers.add(eventHandler);
        eventHandler.onConnectionOpen(this);
    }

    public void startRead() {
        final ByteBuffer buffer = ByteBuffer.allocate(1024);
        this.clientChannel.getChannel().read(buffer, null, new CompletionHandler<Integer, Void>(){
            final /* synthetic */ NioPipeline this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void completed(Integer bytesRead, Void attachment) {
                if (bytesRead > 0) {
                    buffer.flip();
                    byte[] data = new byte[bytesRead.intValue()];
                    buffer.get(data);
                    for (PipelineEventHandler eventHandler : this.this$0.eventHandlers) {
                        eventHandler.onDataRead(this.this$0, data);
                    }
                    this.this$0.processHandlers(data);
                    this.this$0.startRead();
                } else {
                    for (PipelineEventHandler eventHandler : this.this$0.eventHandlers) {
                        eventHandler.onConnectionClose(this.this$0);
                    }
                    this.this$0.close();
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                for (PipelineEventHandler eventHandler : this.this$0.eventHandlers) {
                    eventHandler.onError(this.this$0, exc);
                }
                this.this$0.close();
            }
        });
    }

    private void processHandlers(byte[] data) {
        for (PipelineHandler handler : this.handlers) {
            handler.process(this, data);
        }
    }

    public void writeData(final byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.clientChannel.getChannel().write(buffer, null, new CompletionHandler<Integer, Void>(){
            final /* synthetic */ NioPipeline this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void completed(Integer result, Void attachment) {
                for (PipelineEventHandler eventHandler : this.this$0.eventHandlers) {
                    eventHandler.onDataWrite(this.this$0, data);
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                for (PipelineEventHandler eventHandler : this.this$0.eventHandlers) {
                    eventHandler.onError(this.this$0, exc);
                }
            }
        });
    }

    public void close() {
        try {
            this.clientChannel.close();
        }
        catch (Exception e) {
            System.err.println("Error closing pipeline: " + e.getMessage());
        }
    }

    public AsyncClientChannel getClientChannel() {
        return this.clientChannel;
    }
}

