/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PacketDataType;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PrimitiveDataType;

public class StringPacketData
extends PacketDataType<String> {
    private String value;

    public StringPacketData() {
        super(PrimitiveDataType.STRING);
    }

    public StringPacketData(String value) {
        this();
        this.value = value;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        byte[] stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
        buffer.putInt(stringBytes.length);
        buffer.put(stringBytes);
    }

    @Override
    public String deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] stringBytes = new byte[length];
        buffer.get(stringBytes);
        this.value = new String(stringBytes, StandardCharsets.UTF_8);
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

