/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PacketDataType;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PrimitiveDataType;

public class StringListPacketData
extends PacketDataType<List<String>> {
    private List<String> values = new ArrayList<String>();

    public StringListPacketData() {
        super(PrimitiveDataType.STRING_LIST);
    }

    public StringListPacketData(List<String> values) {
        this();
        this.values = values;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.putInt(this.values.size());
        for (String value : this.values) {
            byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
            buffer.putInt(stringBytes.length);
            buffer.put(stringBytes);
        }
    }

    @Override
    public List<String> deserialize(ByteBuffer buffer) {
        int size = buffer.getInt();
        this.values = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            int length = buffer.getInt();
            byte[] stringBytes = new byte[length];
            buffer.get(stringBytes);
            this.values.add(new String(stringBytes, StandardCharsets.UTF_8));
        }
        return this.values;
    }

    @Override
    public List<String> getValue() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

