/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PacketDataType;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PrimitiveDataType;

public class JsonStringPacketData
extends PacketDataType<String> {
    private String jsonString;

    public JsonStringPacketData() {
        super(PrimitiveDataType.JSON_STRING);
    }

    public JsonStringPacketData(String jsonString) {
        this();
        this.jsonString = jsonString;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        byte[] jsonBytes = this.jsonString.getBytes(StandardCharsets.UTF_8);
        buffer.putInt(jsonBytes.length);
        buffer.put(jsonBytes);
    }

    @Override
    public String deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] jsonBytes = new byte[length];
        buffer.get(jsonBytes);
        this.jsonString = new String(jsonBytes, StandardCharsets.UTF_8);
        return this.jsonString;
    }

    @Override
    public String getValue() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }
}

