/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet.types;

import java.util.ArrayList;
import java.util.List;
import me.syntaxjason.syntaxjasonapi.networking.packet.Packet;
import me.syntaxjason.syntaxjasonapi.networking.packet.PacketType;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PacketDataType;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.PrimitiveDataType;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.BooleanPacketData;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.DoublePacketData;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.FloatPacketData;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.IntPacketData;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.JsonStringPacketData;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.StringListPacketData;
import me.syntaxjason.syntaxjasonapi.networking.packet.ultra.data.StringPacketData;

public class UltraPacket
extends Packet {
    private final List<PacketDataType<?>> dataFields = new ArrayList();

    public UltraPacket() {
        super(PacketType.ULTRA, 1024);
    }

    public <T> void addDataField(PacketDataType<T> dataField) {
        this.dataFields.add(dataField);
    }

    @Override
    public byte[] serialize() {
        this.buffer.clear();
        for (PacketDataType<?> field : this.dataFields) {
            this.buffer.put((byte)field.getType().ordinal());
            field.serialize(this.buffer);
        }
        return this.buffer.array();
    }

    @Override
    public void deserialize(byte[] data) {
        this.buffer.clear();
        this.buffer.put(data);
        this.buffer.flip();
        block9: while (this.buffer.hasRemaining()) {
            PrimitiveDataType type = PrimitiveDataType.values()[this.buffer.get()];
            switch (type) {
                case STRING: {
                    StringPacketData stringData = new StringPacketData();
                    stringData.deserialize(this.buffer);
                    this.dataFields.add(stringData);
                    continue block9;
                }
                case INT: {
                    IntPacketData intData = new IntPacketData();
                    intData.deserialize(this.buffer);
                    this.dataFields.add(intData);
                    continue block9;
                }
                case STRING_LIST: {
                    StringListPacketData stringListData = new StringListPacketData();
                    stringListData.deserialize(this.buffer);
                    this.dataFields.add(stringListData);
                    continue block9;
                }
                case JSON_STRING: {
                    JsonStringPacketData jsonStringData = new JsonStringPacketData();
                    jsonStringData.deserialize(this.buffer);
                    this.dataFields.add(jsonStringData);
                    continue block9;
                }
                case FLOAT: {
                    FloatPacketData floatData = new FloatPacketData();
                    floatData.deserialize(this.buffer);
                    this.dataFields.add(floatData);
                    continue block9;
                }
                case BOOLEAN: {
                    BooleanPacketData booleanData = new BooleanPacketData();
                    booleanData.deserialize(this.buffer);
                    this.dataFields.add(booleanData);
                    continue block9;
                }
                case DOUBLE: {
                    DoublePacketData doubleData = new DoublePacketData();
                    doubleData.deserialize(this.buffer);
                    this.dataFields.add(doubleData);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown data type");
        }
    }

    public List<PacketDataType<?>> getDataFields() {
        return this.dataFields;
    }
}

