/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet.types;

import java.nio.charset.StandardCharsets;
import me.syntaxjason.syntaxjasonapi.networking.packet.Packet;
import me.syntaxjason.syntaxjasonapi.networking.packet.PacketType;

public class StringPacket
extends Packet {
    private int id;
    private String message;

    public StringPacket() {
        super(PacketType.DEFAULT, 128);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public byte[] serialize() {
        this.buffer.clear();
        this.buffer.putInt(this.id);
        byte[] messageBytes = this.message.getBytes(StandardCharsets.UTF_8);
        this.buffer.putInt(messageBytes.length);
        this.buffer.put(messageBytes);
        return this.buffer.array();
    }

    @Override
    public void deserialize(byte[] data) {
        this.buffer.clear();
        this.buffer.put(data);
        this.buffer.flip();
        this.id = this.buffer.getInt();
        int messageLength = this.buffer.getInt();
        byte[] messageBytes = new byte[messageLength];
        this.buffer.get(messageBytes);
        this.message = new String(messageBytes, StandardCharsets.UTF_8);
    }

    public int getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }
}

