/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet.types;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.syntaxjason.syntaxjasonapi.networking.packet.Packet;
import me.syntaxjason.syntaxjasonapi.networking.packet.PacketType;
import me.syntaxjason.syntaxjasonapi.networking.util.DebugLogger;

public class LitePacket
extends Packet {
    private final Map<String, Object> dataMap;
    private ByteBuffer buffer;
    private final DebugLogger logger = DebugLogger.getInstance();

    public LitePacket(PacketType type) {
        super(type);
        this.dataMap = new HashMap<String, Object>();
        this.buffer = ByteBuffer.allocate(256);
    }

    public void addKeyValue(String key, Object value) {
        this.dataMap.put(key, value);
    }

    private void writeVarInt(int value) {
        this.ensureCapacity(5);
        while ((value & 0xFFFFFF80) != 0) {
            this.buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        this.buffer.put((byte)value);
    }

    private int readVarInt() {
        byte read;
        int numRead = 0;
        int result = 0;
        do {
            read = this.buffer.get();
            result |= (read & 0x7F) << 7 * numRead;
            ++numRead;
        } while ((read & 0x80) != 0);
        return result;
    }

    @Override
    public byte[] serialize() {
        this.buffer.clear();
        this.writeVarInt(this.getType().ordinal());
        for (Map.Entry<String, Object> entry : this.dataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            this.ensureCapacity(keyBytes.length + 5);
            this.writeVarInt(keyBytes.length);
            this.buffer.put(keyBytes);
            if (value instanceof String) {
                this.buffer.put((byte)0);
                byte[] valueBytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                this.ensureCapacity(valueBytes.length + 5);
                this.writeVarInt(valueBytes.length);
                this.buffer.put(valueBytes);
                continue;
            }
            if (value instanceof Integer) {
                this.buffer.put((byte)1);
                this.ensureCapacity(5);
                this.writeVarInt((Integer)value);
                continue;
            }
            if (value instanceof Boolean) {
                this.buffer.put((byte)2);
                this.ensureCapacity(1);
                this.buffer.put((byte)((Boolean)value != false ? 1 : 0));
                continue;
            }
            if (value instanceof Float) {
                this.buffer.put((byte)3);
                this.ensureCapacity(4);
                this.buffer.putFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.buffer.put((byte)4);
                this.ensureCapacity(8);
                this.buffer.putDouble((Double)value);
                continue;
            }
            if (value instanceof byte[]) {
                this.buffer.put((byte)5);
                byte[] byteArray = (byte[])value;
                this.ensureCapacity(byteArray.length + 5);
                this.writeVarInt(byteArray.length);
                this.buffer.put(byteArray);
                continue;
            }
            throw new IllegalArgumentException("Unsupported data type for key: " + key);
        }
        byte[] serializedData = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(serializedData);
        return serializedData;
    }

    @Override
    public void deserialize(byte[] data) {
        this.buffer.clear();
        this.ensureCapacity(data.length);
        this.buffer.put(data);
        this.buffer.flip();
        int packetTypeOrdinal = this.readVarInt();
        if (PacketType.values().length <= packetTypeOrdinal || packetTypeOrdinal < 0) {
            throw new IllegalArgumentException("Invalid packet type ordinal: " + packetTypeOrdinal);
        }
        block8: while (this.buffer.hasRemaining()) {
            int keyLength = this.readVarInt();
            this.ensureCapacity(keyLength);
            byte[] keyBytes = new byte[keyLength];
            this.buffer.get(keyBytes);
            String key = new String(keyBytes, StandardCharsets.UTF_8);
            this.ensureCapacity(1);
            byte typeCode = this.buffer.get();
            switch (typeCode) {
                case 0: {
                    int valueLength = this.readVarInt();
                    this.ensureCapacity(valueLength);
                    byte[] valueBytes = new byte[valueLength];
                    this.buffer.get(valueBytes);
                    this.dataMap.put(key, new String(valueBytes, StandardCharsets.UTF_8));
                    continue block8;
                }
                case 1: {
                    this.dataMap.put(key, this.readVarInt());
                    continue block8;
                }
                case 2: {
                    this.ensureCapacity(1);
                    this.dataMap.put(key, this.buffer.get() == 1);
                    continue block8;
                }
                case 3: {
                    this.ensureCapacity(4);
                    this.dataMap.put(key, Float.valueOf(this.buffer.getFloat()));
                    continue block8;
                }
                case 4: {
                    this.ensureCapacity(8);
                    this.dataMap.put(key, this.buffer.getDouble());
                    continue block8;
                }
                case 5: {
                    int byteArrayLength = this.readVarInt();
                    this.ensureCapacity(byteArrayLength);
                    byte[] byteArray = new byte[byteArrayLength];
                    this.buffer.get(byteArray);
                    this.dataMap.put(key, byteArray);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown data type for key: " + key);
        }
    }

    private void ensureCapacity(int additionalBytes) {
        if (this.buffer.remaining() < additionalBytes) {
            int newCapacity = Math.max(this.buffer.capacity() * 2, this.buffer.capacity() + additionalBytes);
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public Object getValueByKey(String key) {
        return this.dataMap.get(key);
    }

    public <T> Optional<T> getValueByKeyAs(String key, Class<T> type) {
        Object value = this.dataMap.get(key);
        return Optional.ofNullable(type.cast(value));
    }
}

