/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason.syntaxjasonapi.networking.packet;

import java.nio.ByteBuffer;
import me.syntaxjason.syntaxjasonapi.networking.packet.Packet;
import me.syntaxjason.syntaxjasonapi.networking.packet.PacketType;
import me.syntaxjason.syntaxjasonapi.networking.packet.types.LitePacket;
import me.syntaxjason.syntaxjasonapi.networking.packet.types.StringPacket;
import me.syntaxjason.syntaxjasonapi.networking.packet.types.UltraPacket;
import me.syntaxjason.syntaxjasonapi.networking.util.DebugLogger;

public class PacketResolver {
    private static final DebugLogger logger = DebugLogger.getInstance();

    public static Packet resolve(ByteBuffer buffer, int bufferSize) {
        if (!buffer.hasRemaining()) {
            logger.error("Buffer is empty, cannot resolve packet.");
            return null;
        }
        byte packetTypeOrdinal = buffer.get();
        if (PacketType.values().length <= packetTypeOrdinal || packetTypeOrdinal < 0) {
            logger.error("Invalid packet type ordinal: " + packetTypeOrdinal);
            return null;
        }
        PacketType packetType = PacketType.values()[packetTypeOrdinal];
        logger.info("Resolving packet of type: " + String.valueOf((Object)packetType));
        return switch (packetType) {
            case PacketType.DEFAULT -> PacketResolver.resolveDefaultPacket(buffer);
            case PacketType.ULTRA -> PacketResolver.resolveUltraPacket(buffer);
            case PacketType.CUSTOM -> PacketResolver.resolveLitePacket(buffer);
            default -> {
                logger.error("Unsupported packet type: " + String.valueOf((Object)packetType));
                yield null;
            }
        };
    }

    public static Packet resolve(ByteBuffer buffer) {
        return PacketResolver.resolve(buffer, 0);
    }

    public static Packet resolve(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return PacketResolver.resolve(buffer);
    }

    private static StringPacket resolveDefaultPacket(ByteBuffer buffer) {
        try {
            StringPacket packet = new StringPacket();
            packet.deserialize(buffer.array());
            return packet;
        }
        catch (Exception e) {
            logger.error("Failed to resolve default packet: " + e.getMessage());
            return null;
        }
    }

    private static UltraPacket resolveUltraPacket(ByteBuffer buffer) {
        try {
            UltraPacket packet = new UltraPacket();
            packet.deserialize(buffer.array());
            return packet;
        }
        catch (Exception e) {
            logger.error("Failed to resolve ultra packet: " + e.getMessage());
            return null;
        }
    }

    private static LitePacket resolveLitePacket(ByteBuffer buffer) {
        try {
            LitePacket packet = new LitePacket(PacketType.CUSTOM);
            packet.deserialize(buffer.array());
            return packet;
        }
        catch (Exception e) {
            logger.error("Failed to resolve LitePacket: " + e.getMessage());
            return null;
        }
    }
}

